/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.IOInMemoryOrFile;
import net.lecousin.framework.io.encoding.Base64Decoder;
import net.lecousin.framework.io.serialization.AbstractDeserializer;
import net.lecousin.framework.io.serialization.Deserializer;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationException;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.json.JSONDeserializationException;
import net.lecousin.framework.json.JSONReaderAsync;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.xml.serialization.XMLDeserializer;

public class JSONDeserializer
extends AbstractDeserializer {
    protected Charset encoding;
    protected JSONReaderAsync input;
    protected IAsync<Exception> eventBack = null;
    private static final String BASE64_OR_STREAM_EXPECTED = "array with base 64 encoded strings, or stream reference";

    public JSONDeserializer() {
        this(StandardCharsets.UTF_8);
    }

    public JSONDeserializer(Charset encoding) {
        this.encoding = encoding;
    }

    static SerializationException convertError(Exception e) {
        return JSONDeserializationException.errorReadingJSON(e);
    }

    protected IAsync<SerializationException> initializeDeserialization(IO.Readable input) {
        this.input = new JSONReaderAsync(input, this.encoding);
        this.input.setMaximumTextSize(this.maxTextSize);
        return new Async(true);
    }

    protected IAsync<SerializationException> finalizeDeserialization() {
        return new Async(true);
    }

    public void setMaximumTextSize(int max) {
        super.setMaximumTextSize(max);
        if (this.input != null) {
            this.input.setMaximumTextSize(this.maxTextSize);
        }
    }

    protected IAsync<Exception> nextEvent() {
        if (this.eventBack != null) {
            IAsync<Exception> ev = this.eventBack;
            this.eventBack = null;
            return ev;
        }
        return this.input.next();
    }

    protected void back() {
        this.eventBack = new Async(true);
    }

    protected AsyncSupplier<Boolean, SerializationException> deserializeBooleanValue(boolean nullable) {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                if (nullable) {
                    result.unblockSuccess(null);
                } else {
                    result.error((Exception)((Object)JSONDeserializationException.unexpectedNull("boolean")));
                }
            } else if (!JSONReaderAsync.EventType.BOOLEAN.equals((Object)this.input.event)) {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("boolean")));
            } else {
                result.unblockSuccess((Object)this.input.bool);
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<? extends Number, SerializationException> deserializeNumericValue(Class<?> type, boolean nullable, Class<? extends IntegerUnit> targetUnit) {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                if (nullable) {
                    result.unblockSuccess(null);
                } else {
                    result.error((Exception)((Object)JSONDeserializationException.unexpectedNull("number")));
                }
            } else if (JSONReaderAsync.EventType.NUMBER.equals((Object)this.input.event)) {
                JSONDeserializer.convertBigDecimalValue((BigDecimal)(this.input.number instanceof BigDecimal ? (BigDecimal)this.input.number : new BigDecimal((BigInteger)this.input.number)), (Class)type, (AsyncSupplier)result);
            } else if (JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
                if (targetUnit != null) {
                    try {
                        result.unblockSuccess((Object)JSONDeserializer.convertStringToInteger((Class)type, (String)this.input.string.asString(), (Class)targetUnit));
                    }
                    catch (Exception e) {
                        result.error((Exception)((Object)new JSONDeserializationException("Error reading numeric value", e)));
                    }
                } else {
                    try {
                        JSONDeserializer.convertBigDecimalValue((BigDecimal)new BigDecimal(this.input.string.asString()), (Class)type, (AsyncSupplier)result);
                    }
                    catch (Exception e) {
                        result.error((Exception)((Object)new JSONDeserializationException("Error reading numeric value", e)));
                    }
                }
            } else {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("number")));
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<? extends CharSequence, SerializationException> deserializeStringValue() {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                result.unblockSuccess(null);
            } else if (!JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("string")));
            } else {
                result.unblockSuccess((Object)this.input.string);
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<Boolean, SerializationException> startCollectionValue() {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                result.unblockSuccess((Object)Boolean.FALSE);
            } else if (!JSONReaderAsync.EventType.START_ARRAY.equals((Object)this.input.event)) {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("array")));
            } else {
                result.unblockSuccess((Object)Boolean.TRUE);
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<Pair<Object, Boolean>, SerializationException> deserializeCollectionValueElement(SerializationContext.CollectionContext context, int elementIndex, String colPath, List<SerializationRule> rules) {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.thenDoOrStart(() -> {
            if (JSONReaderAsync.EventType.END_ARRAY.equals((Object)this.input.event)) {
                result.unblockSuccess((Object)new Pair(null, (Object)Boolean.FALSE));
            } else if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                result.unblockSuccess((Object)new Pair(null, (Object)Boolean.TRUE));
            } else {
                this.back();
                AsyncSupplier value = this.deserializeValue((SerializationContext)context, context.getElementType(), colPath + '[' + elementIndex + ']', rules);
                if (value.isDone()) {
                    if (value.hasError()) {
                        result.error(value.getError());
                    } else {
                        result.unblockSuccess((Object)new Pair(value.getResult(), (Object)Boolean.TRUE));
                    }
                } else {
                    value.onDone(obj -> result.unblockSuccess((Object)new Pair(obj, (Object)Boolean.TRUE)), (IAsync)result);
                }
            }
        }, "Deserializing JSON", this.priority, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<Object, SerializationException> startObjectValue(SerializationContext context, TypeDefinition type, List<SerializationRule> rules) {
        IAsync<Exception> next = this.nextEvent();
        if (next.isDone()) {
            if (next.hasError()) {
                return new AsyncSupplier(null, (Exception)((Object)JSONDeserializationException.errorReadingJSON(next.getError())));
            }
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                return new AsyncSupplier(null, null);
            }
            if (!JSONReaderAsync.EventType.START_OBJECT.equals((Object)this.input.event)) {
                return new AsyncSupplier(null, (Exception)((Object)JSONDeserializationException.unexpectedValue("object")));
            }
            AsyncSupplier result = new AsyncSupplier();
            this.instantiate(context, type, rules, (AsyncSupplier<Object, SerializationException>)result);
            return result;
        }
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                result.unblockSuccess(null);
            } else if (!JSONReaderAsync.EventType.START_OBJECT.equals((Object)this.input.event)) {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("object")));
            } else {
                new AbstractDeserializer.DeserializationTask((AbstractDeserializer)this, () -> this.instantiate(context, type, rules, (AsyncSupplier<Object, SerializationException>)result)).start();
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    private void instantiate(SerializationContext context, TypeDefinition type, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        IAsync<Exception> next = this.nextEvent();
        if (next.isDone()) {
            this.instantiate2(context, type, rules, result);
            return;
        }
        next.onDone(() -> new AbstractDeserializer.DeserializationTask((AbstractDeserializer)this, () -> this.instantiate2(context, type, rules, result)).start(), result, JSONDeserializer::convertError);
    }

    private void instantiate2(SerializationContext context, TypeDefinition type, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        if (JSONReaderAsync.EventType.END_OBJECT.equals((Object)this.input.event)) {
            this.back();
            try {
                result.unblockSuccess(SerializationClass.instantiate((TypeDefinition)type, (SerializationContext)context, rules, (boolean)false));
            }
            catch (Exception e) {
                result.error((Exception)((Object)JSONDeserializationException.instantiationError(e)));
            }
            return;
        }
        if (JSONReaderAsync.EventType.START_ATTRIBUTE.equals((Object)this.input.event)) {
            String attrName = "class";
            while (XMLDeserializer.hasAttribute((Class)type.getBase(), (String)attrName)) {
                attrName = "_" + attrName;
            }
            if (!this.input.string.equals((CharSequence)attrName)) {
                this.back();
                try {
                    result.unblockSuccess(SerializationClass.instantiate((TypeDefinition)type, (SerializationContext)context, rules, (boolean)false));
                }
                catch (Exception e) {
                    result.error((Exception)((Object)JSONDeserializationException.instantiationError(e)));
                }
                return;
            }
            IAsync<Exception> next = this.nextEvent();
            next.thenDoOrStart(() -> {
                if (!JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
                    result.error((Exception)((Object)JSONDeserializationException.unexpectedValue("a string containing a class name")));
                } else {
                    this.instantiate3(context, rules, result);
                }
            }, "JSON Deserialization", this.priority, result, JSONDeserializer::convertError);
            return;
        }
        result.error((Exception)((Object)JSONDeserializationException.unexpected("event " + (Object)((Object)this.input.event), "attribute or end of object")));
    }

    private void instantiate3(SerializationContext context, List<SerializationRule> rules, AsyncSupplier<Object, SerializationException> result) {
        String className = this.input.string.asString();
        try {
            Class<?> cl = Class.forName(className);
            result.unblockSuccess(SerializationClass.instantiate((TypeDefinition)new TypeDefinition(cl, new TypeDefinition[0]), (SerializationContext)context, rules, (boolean)true));
        }
        catch (Exception e) {
            result.error((Exception)((Object)JSONDeserializationException.instantiationError(e)));
        }
    }

    protected AsyncSupplier<String, SerializationException> deserializeObjectAttributeName(SerializationContext.ObjectContext context) {
        IAsync<Exception> next = this.nextEvent();
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.START_ATTRIBUTE.equals((Object)this.input.event)) {
                result.unblockSuccess((Object)this.input.string.asString());
            } else if (JSONReaderAsync.EventType.END_OBJECT.equals((Object)this.input.event)) {
                result.unblockSuccess(null);
            } else {
                result.error((Exception)((Object)JSONDeserializationException.unexpected("event " + (Object)((Object)this.input.event), "attribute or end of object")));
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    protected AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableValue(SerializationContext context, List<SerializationRule> rules) {
        IAsync<Exception> next = this.nextEvent();
        if (next.isDone()) {
            if (next.hasError()) {
                return new AsyncSupplier(null, (Exception)((Object)JSONDeserializationException.errorReadingJSON(next.getError())));
            }
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                return new AsyncSupplier(null, null);
            }
            if (JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
                String ref = this.input.string.asString();
                for (Deserializer.StreamReferenceHandler h : this.streamReferenceHandlers) {
                    if (!h.isReference(ref)) continue;
                    return h.getStreamFromReference(ref);
                }
            }
            if (!JSONReaderAsync.EventType.START_ARRAY.equals((Object)this.input.event)) {
                return new AsyncSupplier(null, (Exception)((Object)JSONDeserializationException.unexpectedValue(BASE64_OR_STREAM_EXPECTED)));
            }
            AsyncSupplier result = new AsyncSupplier();
            this.startDecodeBase64((AsyncSupplier<IO.Readable, SerializationException>)result);
            return result;
        }
        AsyncSupplier result = new AsyncSupplier();
        next.onDone(() -> {
            if (JSONReaderAsync.EventType.NULL.equals((Object)this.input.event)) {
                result.unblockSuccess(null);
            } else if (JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
                String ref = this.input.string.asString();
                for (Deserializer.StreamReferenceHandler h : this.streamReferenceHandlers) {
                    if (!h.isReference(ref)) continue;
                    h.getStreamFromReference(ref).forward(result);
                    return;
                }
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue(BASE64_OR_STREAM_EXPECTED)));
            } else if (!JSONReaderAsync.EventType.START_ARRAY.equals((Object)this.input.event)) {
                result.error((Exception)((Object)JSONDeserializationException.unexpectedValue(BASE64_OR_STREAM_EXPECTED)));
            } else {
                new AbstractDeserializer.DeserializationTask((AbstractDeserializer)this, () -> this.startDecodeBase64((AsyncSupplier<IO.Readable, SerializationException>)result)).start();
            }
        }, (IAsync)result, JSONDeserializer::convertError);
        return result;
    }

    private void startDecodeBase64(AsyncSupplier<IO.Readable, SerializationException> result) {
        IOInMemoryOrFile io = new IOInMemoryOrFile(131072, this.priority, "base 64 encoded from XML");
        Base64Decoder decoder = new Base64Decoder((IO.Writable)io);
        this.readNextBase64(decoder, io, result);
    }

    private void readNextBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result) {
        Async<Exception> next = this.input.next();
        if (next.isDone()) {
            if (next.hasError()) {
                result.error((Exception)((Object)JSONDeserializationException.errorReadingJSON(next.getError())));
            } else {
                this.readBase64(decoder, io, result);
            }
            return;
        }
        next.thenStart((Task)new AbstractDeserializer.DeserializationTask((AbstractDeserializer)this, () -> this.readBase64(decoder, io, result)), result, JSONDeserializer::convertError);
    }

    private void readBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result) {
        if (JSONReaderAsync.EventType.STRING.equals((Object)this.input.event)) {
            if (this.input.string.length() == 0) {
                this.readNextBase64(decoder, io, result);
                return;
            }
            CharBuffer[] buffers = this.input.string.asCharBuffers();
            this.decodeBase64(decoder, io, result, buffers, 0);
            return;
        }
        if (JSONReaderAsync.EventType.END_ARRAY.equals((Object)this.input.event)) {
            decoder.flush().onDone(() -> io.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L).onDone(() -> result.unblockSuccess((Object)io), (IAsync)result, JSONDeserializer::convertError), result, JSONDeserializer::convertError);
            return;
        }
        this.readNextBase64(decoder, io, result);
    }

    private void decodeBase64(Base64Decoder decoder, IOInMemoryOrFile io, AsyncSupplier<IO.Readable, SerializationException> result, CharBuffer[] buffers, int index) {
        IAsync decode = decoder.decode(buffers[index]);
        decode.thenStart((Task)new AbstractDeserializer.DeserializationTask((AbstractDeserializer)this, () -> {
            if (decode.hasError()) {
                result.error((Exception)((Object)new JSONDeserializationException("Error decoding base 64", decode.getError())));
            } else if (index == buffers.length - 1) {
                this.readNextBase64(decoder, io, result);
            } else {
                this.decodeBase64(decoder, io, result, buffers, index + 1);
            }
        }), true);
    }

    protected AsyncSupplier<IO.Readable, SerializationException> deserializeIOReadableAttributeValue(SerializationContext.AttributeContext context, List<SerializationRule> rules) {
        return this.deserializeIOReadableValue((SerializationContext)context, rules);
    }
}

