/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection.xml;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.injection.Factory;
import net.lecousin.framework.injection.Injectable;
import net.lecousin.framework.injection.InjectableWhen;
import net.lecousin.framework.injection.Injection;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.ObjectAttribute;
import net.lecousin.framework.injection.ObjectMethod;
import net.lecousin.framework.injection.ObjectValue;
import net.lecousin.framework.injection.ObjectValueClass;
import net.lecousin.framework.injection.ObjectValueFromSingletonAttributeById;
import net.lecousin.framework.injection.ObjectValueFromSingletonAttributeByType;
import net.lecousin.framework.injection.ObjectValueFromString;
import net.lecousin.framework.injection.ObjectValueList;
import net.lecousin.framework.injection.ObjectValueMap;
import net.lecousin.framework.injection.ObjectValueRefId;
import net.lecousin.framework.injection.ObjectValueRefType;
import net.lecousin.framework.injection.Singleton;
import net.lecousin.framework.injection.xml.InjectionXmlConfiguration;
import net.lecousin.framework.injection.xml.InjectionXmlParser;
import net.lecousin.framework.properties.Property;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public class InjectionXmlParser01
implements InjectionXmlParser {
    @Override
    public void configureInjection(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        Application app = LCCore.getApplication();
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.localName.equals((CharSequence)"Singleton")) {
                InjectionXmlParser01.configureObjectProvider(ctx, app, xml, true);
                continue;
            }
            if (xml.event.localName.equals((CharSequence)"Factory")) {
                InjectionXmlParser01.configureObjectProvider(ctx, app, xml, false);
                continue;
            }
            if (xml.event.localName.equals((CharSequence)"property")) {
                InjectionXmlParser01.configureProperty(ctx, app, xml);
                continue;
            }
            if (xml.event.localName.equals((CharSequence)"scan-package")) {
                InjectionXmlParser01.configureScanPackage(ctx, app, xml);
                continue;
            }
            if (xml.event.localName.equals((CharSequence)"import")) {
                InjectionXmlParser01.configureImport(ctx, app, xml);
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString() + " in Injection");
        }
    }

    private static void configureProperty(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing name of property");
        }
        UnprotectedStringBuffer value = xml.getAttributeValueByLocalName((CharSequence)"value");
        if (value == null) {
            throw new Exception("Missing value of property");
        }
        String val = Injection.resolveProperties(ctx, app, value.asString());
        ctx.setProperty(name.asString(), val);
        if (!xml.event.isClosed) {
            xml.closeElement();
        }
    }

    private static void configureObjectProvider(InjectionContext ctx, Application app, XMLStreamReader xml, boolean isSingleton) throws Exception {
        UnprotectedStringBuffer id = xml.getAttributeValueByLocalName((CharSequence)"id");
        String typeStr = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"type"));
        Class<Object> type = typeStr != null ? app.getClassLoader().loadClass(typeStr) : null;
        Class cl = null;
        LinkedList<ObjectAttribute> attributes = null;
        ObjectMethod initMethod = null;
        ObjectMethod destroyMethod = null;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.localName.equals((CharSequence)"class")) {
                List list;
                UnprotectedStringBuffer n = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (n == null) {
                    throw new Exception("Missing attribute name on element class");
                }
                String name = Injection.resolveProperties(ctx, app, n.asString());
                boolean eligible = true;
                LinkedList<ObjectAttribute> attrs = new LinkedList<ObjectAttribute>();
                ObjectMethod init = null;
                ObjectMethod destroy = null;
                XMLStreamEvents.ElementContext elemClass = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                while (xml.nextInnerElement(elemClass)) {
                    if (xml.event.localName.equals((CharSequence)"property")) {
                        UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                        if (pname == null) {
                            throw new Exception("Missing attribute name on element property");
                        }
                        Property[] pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                        if (pvalue == null) {
                            throw new Exception("Missing attribute value on property " + pname);
                        }
                        eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                        continue;
                    }
                    if (xml.event.localName.equals((CharSequence)"attribute")) {
                        attrs.add(InjectionXmlParser01.readObjectAttribute(ctx, xml, app));
                        continue;
                    }
                    if (xml.event.localName.equals((CharSequence)"init-method")) {
                        if (init != null) {
                            throw new Exception("Only one init-method can be specified for class " + name);
                        }
                        init = InjectionXmlParser01.readObjectMethod(ctx, xml, app);
                        continue;
                    }
                    if (isSingleton && xml.event.localName.equals((CharSequence)"destroy-method")) {
                        if (destroy != null) {
                            throw new Exception("Only one destroy-method can be specified for class " + name);
                        }
                        destroy = InjectionXmlParser01.readObjectMethod(ctx, xml, app);
                        if (destroy.getParameters().isEmpty()) continue;
                        throw new Exception("destroy-method cannot have parameters");
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString());
                }
                if (!eligible) continue;
                try {
                    cl = app.getClassLoader().loadClass(name);
                }
                catch (Throwable t) {
                    continue;
                }
                InjectableWhen when = cl.getAnnotation(InjectableWhen.class);
                if (when != null) {
                    for (Property p : when.value()) {
                        String pname = p.name();
                        String pvalue = p.value();
                        if ((pvalue = Injection.resolveProperties(ctx, app, pvalue)).equals(Injection.getProperty(app, ctx, pname))) continue;
                        eligible = false;
                        break;
                    }
                }
                if (!eligible) continue;
                if (type == null) {
                    Injectable it = cl.getAnnotation(Injectable.class);
                    type = it == null ? cl : it.value();
                }
                if (init != null) {
                    list = ClassUtil.getMethods((Class)cl, (String)init.getName(), (int)init.getParameters().size());
                    if (list.isEmpty()) {
                        throw new Exception("Init method " + init.getName() + " does not exist on class " + cl.getName());
                    }
                    if (list.size() > 1) {
                        throw new Exception("Init method " + init.getName() + " is ambiguous on class " + cl.getName());
                    }
                }
                if (destroy != null && (list = ClassUtil.getMethods((Class)cl, (String)destroy.getName(), (int)0)).isEmpty()) {
                    throw new Exception("Destroy method " + destroy.getName() + " does not exist on class " + cl.getName());
                }
                initMethod = init;
                destroyMethod = destroy;
                attributes = attrs;
                break;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (cl == null || type == null) {
            return;
        }
        if (isSingleton) {
            ctx.add(new Singleton(ctx, type, Injection.create(ctx, cl, initMethod, attributes), id != null ? id.asString() : null, destroyMethod));
        } else {
            ctx.add(new Factory(ctx, type, cl, initMethod, attributes, id != null ? id.asString() : null));
        }
    }

    private static void configureScanPackage(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        String pkgName = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"package"));
        if (pkgName == null) {
            throw new Exception("Missing package attribute on element scan-package");
        }
        boolean singletons = true;
        UnprotectedStringBuffer s = xml.getAttributeValueByLocalName((CharSequence)"singleton");
        if (s != null && s.toLowerCase().equals((CharSequence)"false")) {
            singletons = false;
        }
        boolean eligible = true;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.localName.equals((CharSequence)"property")) {
                UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (pname == null) {
                    throw new Exception("Missing attribute name on element property");
                }
                String pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                if (pvalue == null) {
                    throw new Exception("Missing attribute value on property " + pname);
                }
                eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (!eligible) {
            return;
        }
        Injection.scanPackage(ctx, app, pkgName, singletons);
    }

    private static void configureImport(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        String filename = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"file"));
        if (filename == null) {
            throw new Exception("Missing file attribute on element import");
        }
        boolean eligible = true;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.localName.equals((CharSequence)"property")) {
                UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (pname == null) {
                    throw new Exception("Missing attribute name on element property");
                }
                String pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                if (pvalue == null) {
                    throw new Exception("Missing attribute value on property " + pname);
                }
                eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (!eligible) {
            return;
        }
        InjectionXmlConfiguration.configure(ctx, filename).blockThrow(0L);
    }

    public static ObjectAttribute readObjectAttribute(InjectionContext ctx, XMLStreamReader xml, Application app) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing attribute name on element 'attribute'");
        }
        ObjectValue value = InjectionXmlParser01.readObjectValue(ctx, xml, app);
        return new ObjectAttribute(name.asString(), value);
    }

    public static ObjectValue readObjectValue(InjectionContext ctx, XMLStreamReader xml, Application app) throws Exception {
        String s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
        if (s != null) {
            return new ObjectValueFromString(s);
        }
        s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"ref"));
        if (s != null) {
            return new ObjectValueRefId(s);
        }
        s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"refType"));
        if (s != null) {
            return new ObjectValueRefType(app.getClassLoader().loadClass(s));
        }
        s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"class"));
        if (s != null) {
            Class cl = app.getClassLoader().loadClass(s);
            LinkedList<ObjectValue> params = new LinkedList<ObjectValue>();
            LinkedList<ObjectAttribute> attrs = new LinkedList<ObjectAttribute>();
            if (!xml.event.isClosed) {
                XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                while (xml.nextInnerElement(elem)) {
                    if (xml.event.localName.equals((CharSequence)"parameter")) {
                        params.add(InjectionXmlParser01.readObjectValue(ctx, xml, app));
                        continue;
                    }
                    if (xml.event.localName.equals((CharSequence)"attribute")) {
                        attrs.add(InjectionXmlParser01.readObjectAttribute(ctx, xml, app));
                        continue;
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString());
                }
            }
            return new ObjectValueClass(cl, params, attrs);
        }
        if (xml.event.isClosed) {
            throw new Exception("Invalid element " + xml.event.text.asString() + ": no value specified");
        }
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        if (xml.nextInnerElement(elem)) {
            if (xml.event.localName.equals((CharSequence)"from")) {
                String attrName = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"attribute"));
                if (attrName == null) {
                    throw new Exception("Missing attribute 'attribute' on element 'from'");
                }
                s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"ref"));
                if (s != null) {
                    xml.closeElement();
                    return new ObjectValueFromSingletonAttributeById(attrName, s);
                }
                s = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"refType"));
                if (s != null) {
                    xml.closeElement();
                    return new ObjectValueFromSingletonAttributeByType(attrName, app.getClassLoader().loadClass(s));
                }
                throw new Exception("Missing attribute 'ref' or 'refType' on element 'from'");
            }
            if (xml.event.localName.equals((CharSequence)"list")) {
                XMLStreamEvents.ElementContext elemList = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                LinkedList<ObjectValue> list = new LinkedList<ObjectValue>();
                while (xml.nextInnerElement(elemList)) {
                    if (xml.event.localName.equals((CharSequence)"element")) {
                        list.add(InjectionXmlParser01.readObjectValue(ctx, xml, app));
                        continue;
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString() + " in list");
                }
                return new ObjectValueList(list);
            }
            if (xml.event.localName.equals((CharSequence)"map")) {
                XMLStreamEvents.ElementContext elemList = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                LinkedList<ObjectAttribute> list = new LinkedList<ObjectAttribute>();
                while (xml.nextInnerElement(elemList)) {
                    if (xml.event.localName.equals((CharSequence)"entry")) {
                        list.add(InjectionXmlParser01.readObjectAttribute(ctx, xml, app));
                        continue;
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString() + " in map");
                }
                return new ObjectValueMap(list);
            }
            throw new Exception("Unexpected element " + xml.event.text.asString() + " in " + elem.localName);
        }
        throw new Exception("Invalid element " + xml.event.text.asString() + ": no value specified");
    }

    public static ObjectMethod readObjectMethod(InjectionContext ctx, XMLStreamReader xml, Application app) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing attribute name on element '" + xml.event.text.asString() + "'");
        }
        LinkedList<ObjectValue> params = new LinkedList<ObjectValue>();
        if (!xml.event.isClosed) {
            XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
            while (xml.nextInnerElement(elem)) {
                if (xml.event.localName.equals((CharSequence)"parameter")) {
                    params.add(InjectionXmlParser01.readObjectValue(ctx, xml, app));
                    continue;
                }
                throw new Exception("Unexpected element " + xml.event.text.asString());
            }
        }
        return new ObjectMethod(name.asString(), params);
    }
}

