/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection.xml;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.xml.InjectionXmlParser01;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public final class InjectionXmlConfiguration {
    public static final String NAMESPACE_URI_0_1 = "http://code.lecousin.net/java/net.lecousin.framework.injection/0.1";

    private InjectionXmlConfiguration() {
    }

    public static ISynchronizationPoint<Exception> configure(InjectionContext ctx, String filename) {
        IOProvider.Readable provider = LCCore.getApplication().getClassLoader().getIOProvider(filename);
        if (provider == null) {
            return new SynchronizationPoint((Exception)new FileNotFoundException(filename));
        }
        try {
            return InjectionXmlConfiguration.configure(ctx, provider.provideIOReadable((byte)3));
        }
        catch (IOException e) {
            return new SynchronizationPoint((Exception)e);
        }
    }

    public static ISynchronizationPoint<Exception> configure(final InjectionContext ctx, final IO.Readable xml) {
        Object bio = xml instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)xml : new PreBufferedReadable(xml, 16384, 3, 16384, 4, 4);
        final SynchronizationPoint result = new SynchronizationPoint();
        XMLStreamReader.start((IO.Readable.Buffered)bio, (int)15000).listenInline(reader -> new Task.Cpu<Void, NoException>("Parsing Injection XML file", 4){

            public Void run() {
                try {
                    InjectionXmlConfiguration.configure(ctx, reader);
                    result.unblock();
                }
                catch (Exception e) {
                    result.error(e);
                }
                finally {
                    xml.closeAsync();
                }
                return null;
            }
        }.start(), error -> {
            xml.closeAsync();
            result.error(error);
        }, cancel -> {
            xml.closeAsync();
            result.cancel(cancel);
        });
        return result;
    }

    private static void configure(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
            try {
                xml.next();
            }
            catch (EOFException e) {
                throw new Exception("Invalid XML: no root element");
            }
        }
        InjectionXmlConfiguration.configureInjection(ctx, xml);
    }

    public static void configureInjection(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        if (!xml.event.localName.equals((CharSequence)"Injection")) {
            throw new Exception("Invalid XML: root element must be Injection");
        }
        if (!xml.event.namespaceURI.equals((CharSequence)NAMESPACE_URI_0_1)) {
            throw new Exception("Unknown injection namespace: " + xml.event.namespaceURI);
        }
        new InjectionXmlParser01().configureInjection(ctx, xml);
    }
}

