/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.reflect.Method;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.injection.DestroyMethod;
import net.lecousin.framework.injection.Injection;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.ObjectMethod;
import net.lecousin.framework.injection.ObjectProvider;

public class Singleton
extends ObjectProvider {
    protected Object instance;
    protected ObjectMethod destroy;

    public Singleton(InjectionContext ctx, Class<?> type, Object instance, String id, ObjectMethod destroy) {
        super(ctx, type, id);
        this.instance = instance;
        this.destroy = destroy;
    }

    @Override
    public Object provide() {
        return this.instance;
    }

    @Override
    public void close() {
        if (this.instance == null) {
            return;
        }
        if (this.destroy != null) {
            try {
                Injection.call(this.ctx, this.instance, this.destroy);
            }
            catch (Exception e) {
                LCCore.getApplication().getDefaultLogger().error("Error calling destroy method", (Throwable)e);
            }
        }
        for (Method m : this.instance.getClass().getMethods()) {
            if (m.getAnnotation(DestroyMethod.class) == null || m.getParameterCount() != 0) continue;
            try {
                m.invoke(this.instance, new Object[0]);
            }
            catch (Throwable t) {
                LCCore.getApplication().getDefaultLogger().error("Error calling method " + m.getName() + " on class " + this.instance.getClass().getName(), t);
            }
        }
        this.instance = null;
    }
}

