/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectAttribute;
import net.lecousin.framework.injection.ObjectValue;
import net.lecousin.framework.io.serialization.SerializationClass;

public class ObjectValueMap
implements ObjectValue {
    private List<ObjectAttribute> elements;

    public ObjectValueMap(List<ObjectAttribute> elements) {
        this.elements = elements;
    }

    @Override
    public <T> T create(InjectionContext ctx, Class<T> type, Type genericType, Annotation[] annotations) throws InjectionException {
        Object genericTypeOfElement;
        Class<Object> typeOfElement;
        Map map;
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
            try {
                map = (Map)type.newInstance();
            }
            catch (Exception e) {
                throw new InjectionException("Unable to instantiate map", e);
            }
        }
        try {
            map = (Map)SerializationClass.instantiate(type);
        }
        catch (Exception e) {
            throw new InjectionException("Unable to instantiate map", e);
        }
        if (!(genericType instanceof ParameterizedType)) {
            typeOfElement = Object.class;
            genericTypeOfElement = Object.class;
        } else {
            Type t;
            genericTypeOfElement = ((ParameterizedType)genericType).getActualTypeArguments()[1];
            typeOfElement = genericTypeOfElement instanceof ParameterizedType ? ((t = ((ParameterizedType)genericTypeOfElement).getRawType()) instanceof Class ? (Class<Object>)t : Object.class) : (genericTypeOfElement instanceof Class ? (Class<Object>)genericTypeOfElement : Object.class);
        }
        for (ObjectAttribute elem : this.elements) {
            map.put(elem.getName(), elem.getValue().create(ctx, typeOfElement, (Type)genericTypeOfElement, new Annotation[0]));
        }
        return (T)map;
    }
}

