/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.ArrayUtil;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectValue;
import net.lecousin.framework.io.serialization.SerializationClass;

public class ObjectValueList
implements ObjectValue {
    private List<ObjectValue> elements;

    public ObjectValueList(List<ObjectValue> elements) {
        this.elements = elements;
    }

    @Override
    public <T> T create(InjectionContext ctx, Class<T> type, Type genericType, Annotation[] annotations) throws InjectionException {
        Object genericTypeOfElement;
        Class<Object> typeOfElement;
        Collection<?> list;
        if (type.isArray()) {
            list = new LinkedList();
            typeOfElement = type.getComponentType();
            genericTypeOfElement = type.getComponentType();
        } else {
            if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
                try {
                    list = (Collection)type.newInstance();
                }
                catch (Exception e) {
                    throw new InjectionException("Unable to instantiate collection", e);
                }
            }
            try {
                list = (Collection)SerializationClass.instantiate(type);
            }
            catch (Exception e) {
                throw new InjectionException("Unable to instantiate collection", e);
            }
            if (!(genericType instanceof ParameterizedType)) {
                typeOfElement = Object.class;
                genericTypeOfElement = Object.class;
            } else {
                Type t;
                genericTypeOfElement = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                typeOfElement = genericTypeOfElement instanceof ParameterizedType ? ((t = ((ParameterizedType)genericTypeOfElement).getRawType()) instanceof Class ? (Class<Object>)t : Object.class) : (genericTypeOfElement instanceof Class ? (Class<Object>)genericTypeOfElement : Object.class);
            }
        }
        for (ObjectValue elem : this.elements) {
            list.add(elem.create(ctx, typeOfElement, (Type)genericTypeOfElement, new Annotation[0]));
        }
        if (type.isArray()) {
            return (T)list.toArray(ArrayUtil.createGenericArrayOf((int)list.size(), type.getComponentType()));
        }
        return (T)list;
    }
}

