/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectValue;
import net.lecousin.framework.util.ClassUtil;

public abstract class ObjectValueFromSingletonAttribute
implements ObjectValue {
    protected String attributeName;

    public ObjectValueFromSingletonAttribute(String attributeName) {
        this.attributeName = attributeName;
    }

    protected abstract Object getInstance(InjectionContext var1) throws InjectionException;

    @Override
    public <T> T create(InjectionContext ctx, Class<T> type, Type genericType, Annotation[] annotations) throws InjectionException {
        Object o = this.getInstance(ctx);
        if (o == null) {
            return null;
        }
        Class<?> cl = o.getClass();
        Field f = ClassUtil.getField(cl, (String)this.attributeName);
        if (f != null && type.isAssignableFrom(f.getType())) {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            try {
                return (T)f.get(o);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access to attribute " + this.attributeName + " on class " + cl.getName());
            }
        }
        Method getter = ClassUtil.getGetter(cl, (String)this.attributeName);
        if (getter != null && (getter.getModifiers() & 1) != 0 && type.isAssignableFrom(getter.getReturnType())) {
            try {
                return (T)getter.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access to attribute " + this.attributeName + " on class " + cl.getName());
            }
            catch (InvocationTargetException e) {
                throw new InjectionException("Error while accessing to attribute " + this.attributeName + " on class " + cl.getName(), e);
            }
        }
        throw new InjectionException("Attribute " + this.attributeName + " with type " + type.getName() + " not found on class " + cl.getName());
    }
}

