/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.util.List;
import net.lecousin.framework.injection.Inject;
import net.lecousin.framework.injection.Injection;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class InjectionSerializationRule
implements SerializationRule {
    private InjectionContext context;

    public InjectionSerializationRule(InjectionContext context) {
        this.context = context;
    }

    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        for (SerializationClass.Attribute a : type.getAttributes()) {
            if (a.getField() == null || a.getField().getAnnotation(Inject.class) == null) continue;
            a.ignore(true);
        }
        return false;
    }

    public boolean isEquivalent(SerializationRule rule) {
        return rule instanceof InjectionSerializationRule;
    }

    public void onInstantiation(TypeDefinition type, Object instance, SerializationContext context) throws Exception {
        Injection.inject(this.context, instance);
    }
}

