/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectMethod;
import net.lecousin.framework.injection.ObjectProvider;
import net.lecousin.framework.injection.Singleton;

public class InjectionContext
implements Closeable {
    private InjectionContext parent;
    private List<InjectionContext> children = new ArrayList<InjectionContext>(2);
    private Map<String, String> properties = new HashMap<String, String>();
    private LinkedArrayList<ObjectProvider> providers = new LinkedArrayList(10);
    private Map<String, ObjectProvider> providerById = new HashMap<String, ObjectProvider>();

    public static InjectionContext getRoot() {
        return (InjectionContext)LCCore.getApplication().getInstance(InjectionContext.class);
    }

    public InjectionContext(InjectionContext parent) {
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public InjectionContext() {
        this(null);
    }

    public InjectionContext getParent() {
        return this.parent;
    }

    public void setParent(InjectionContext parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public void close() {
        for (InjectionContext ctx : this.children) {
            ctx.close();
        }
        for (ObjectProvider provider : this.providers) {
            provider.close();
        }
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        String value = this.properties.get(name);
        if (value == null && this.parent != null) {
            return this.parent.getProperty(name);
        }
        return value;
    }

    public Object getObjectById(String id) throws InjectionException {
        ObjectProvider provider = this.providerById.get(id);
        if (provider == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id);
        }
        return provider.provide();
    }

    public <T> T getObjectById(String id, Class<T> type) throws InjectionException {
        ObjectProvider provider = this.providerById.get(id);
        if (provider == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id, type);
        }
        if (!type.isAssignableFrom(provider.getType())) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id, type);
        }
        return (T)provider.provide();
    }

    public <T> T getObject(Class<T> type) throws InjectionException {
        for (ObjectProvider provider : this.providers) {
            if (!type.isAssignableFrom(provider.getType())) continue;
            return (T)provider.provide();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getObject(type);
    }

    public Object searchObjectInChildren(String id) throws InjectionException {
        ObjectProvider provider = this.providerById.get(id);
        if (provider != null) {
            return provider.provide();
        }
        for (InjectionContext child : this.children) {
            Object result = child.searchObjectInChildren(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void add(ObjectProvider provider) throws InjectionException {
        String id = provider.getId();
        if (id != null) {
            if (this.providerById.containsKey(id)) {
                throw new InjectionException("Duplicate object provider with id " + id);
            }
            this.providerById.put(id, provider);
        }
        this.providers.add((Object)provider);
    }

    public void setObject(String id, Class<?> type, Object instance, ObjectMethod destroy) throws InjectionException {
        this.add(new Singleton(this, type, instance, id, destroy));
    }
}

