/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.ArrayUtil;
import net.lecousin.framework.injection.Factory;
import net.lecousin.framework.injection.InitMethod;
import net.lecousin.framework.injection.Inject;
import net.lecousin.framework.injection.Injectable;
import net.lecousin.framework.injection.InjectableWhen;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectAttribute;
import net.lecousin.framework.injection.ObjectMethod;
import net.lecousin.framework.injection.ObjectValue;
import net.lecousin.framework.injection.SingletonOnDemand;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.properties.Property;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.Provider;
import net.lecousin.framework.util.StringFormat;
import net.lecousin.framework.util.StringParser;

public final class Injection {
    private Injection() {
    }

    public static String getProperty(Application app, InjectionContext ctx, String name) {
        String value = ctx.getProperty(name);
        if (value == null) {
            value = app.getProperty(name);
        }
        return value;
    }

    public static Object create(InjectionContext ctx, Class<?> clazz, ObjectMethod initMethod, List<ObjectAttribute> attrs) throws InjectionException {
        return Injection.create(ctx, clazz, new LinkedList<ObjectValue>(), initMethod, attrs);
    }

    public static <T> T create(InjectionContext ctx, Class<T> clazz, List<ObjectValue> params, ObjectMethod initMethod, List<ObjectAttribute> attrs) throws InjectionException {
        if (params == null) {
            params = new ArrayList<ObjectValue>(0);
        }
        if (attrs == null) {
            attrs = new ArrayList<ObjectAttribute>(0);
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        T bean = null;
        for (Constructor<?> ctor : ctors) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != params.size()) continue;
            Object[] objects = new Object[types.length];
            Type[] genericTypes = ctor.getGenericParameterTypes();
            Annotation[][] annotations = ctor.getParameterAnnotations();
            for (int i = 0; i < types.length; ++i) {
                try {
                    objects[i] = params.get(i).create(ctx, types[i], genericTypes[i], annotations[i]);
                    continue;
                }
                catch (InjectionException e) {
                    objects = null;
                    break;
                }
            }
            if (objects == null) continue;
            try {
                bean = (T)ctor.newInstance(objects);
                break;
            }
            catch (Exception e) {
                throw new InjectionException("Error in constructor while instantiating " + clazz.getName(), e);
            }
        }
        if (bean == null) {
            throw new InjectionException("Unable to instantiate " + clazz.getName() + " with given parameters");
        }
        for (ObjectAttribute attr : attrs) {
            Injection.injectAttribute(ctx, bean, attr);
        }
        Injection.inject(ctx, bean);
        for (Method m : clazz.getMethods()) {
            if (m.getAnnotation(InitMethod.class) == null || m.getParameterCount() != 0) continue;
            try {
                m.invoke(bean, new Object[0]);
            }
            catch (Throwable t) {
                throw new InjectionException("Error calling method " + m.getName() + " on class " + clazz.getName());
            }
        }
        if (initMethod != null) {
            try {
                Injection.call(ctx, bean, initMethod);
            }
            catch (Throwable t) {
                throw new InjectionException("Error calling method " + initMethod.getName() + " on class " + clazz.getName());
            }
        }
        return bean;
    }

    public static <T> T createObjectFromString(Class<T> type, Type genericType, String value, Annotation[] annotations) throws InjectionException {
        if ("null".equals(value)) {
            return null;
        }
        for (Annotation a : annotations) {
            if (!(a instanceof StringFormat)) continue;
            try {
                return (T)StringParser.parse(type, (StringFormat)((StringFormat)a), (String)value);
            }
            catch (Exception e) {
                throw new InjectionException("Cannot convert string " + value + " into type " + type.getName(), e);
            }
        }
        if (String.class.equals(type)) {
            return (T)value;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return (T)("true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type) || Integer.TYPE.equals(type) || Integer.class.equals(type) || Short.TYPE.equals(type) || Short.class.equals(type) || Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            long val;
            value = value.trim();
            int i = 0;
            if (value.length() > 1 && value.charAt(0) == '-') {
                ++i;
            }
            while (i < value.length() && Character.isDigit(value.charAt(i))) {
                ++i;
            }
            if (i == value.length()) {
                val = Long.parseLong(value);
            } else {
                Class expectedUnit = null;
                for (Annotation a : annotations) {
                    if (!IntegerUnit.Unit.class.equals(a.annotationType())) continue;
                    expectedUnit = ((IntegerUnit.Unit)a).value();
                    break;
                }
                if (expectedUnit == null) {
                    throw new InjectionException("Invalid value '" + value + "' for type " + type.getName());
                }
                val = Long.parseLong(value.substring(0, i).trim());
                String s = value.substring(i).trim().toLowerCase();
                Class unit = IntegerUnit.ParserRegistry.get((String)s);
                if (unit == null) {
                    throw new InjectionException("Unknown integer unit " + s + " in value " + value);
                }
                try {
                    val = IntegerUnit.ConverterRegistry.convert((long)val, (Class)unit, (Class)expectedUnit);
                }
                catch (IntegerUnit.UnitConversionException e) {
                    throw new InjectionException("Cannot convert value", e);
                }
            }
            if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                return (T)Long.valueOf(val);
            }
            if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                    return (T)Integer.valueOf((int)val);
                }
                throw new InjectionException("Invalid integer value " + val + ": does not fit integer limits");
            }
            if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                if (val >= -32768L && val <= 32767L) {
                    return (T)Short.valueOf((short)val);
                }
                throw new InjectionException("Invalid short value " + val + ": does not fit short limits");
            }
            if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
                if (val >= -128L && val <= 127L) {
                    return (T)Byte.valueOf((byte)val);
                }
                throw new InjectionException("Invalid byte value " + val + ": does not fit byte limits");
            }
        }
        if (Collection.class.isAssignableFrom(type)) {
            try {
                String[] values;
                Collection col;
                if (!(genericType instanceof ParameterizedType)) {
                    throw new InjectionException("Cannot convert a string into a non-parameterized collection " + type.getName());
                }
                if ((genericType = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                    genericType = ((ParameterizedType)genericType).getRawType();
                }
                if (!(genericType instanceof Class)) {
                    throw new InjectionException("Cannot convert a string into a collection " + type.getName());
                }
                try {
                    col = (Collection)SerializationClass.instantiate(type);
                }
                catch (Exception e) {
                    throw new InjectionException("Unable to instantiate collection", e);
                }
                for (String val : values = value.split(",")) {
                    col.add(Injection.createObjectFromString((Class)genericType, null, val, annotations));
                }
                return (T)col;
            }
            catch (InjectionException e1) {
                try {
                    return (T)StringParser.parse(type, (String)value);
                }
                catch (Exception e) {
                    throw e1;
                }
            }
        }
        if (type.isArray()) {
            String[] values;
            LinkedList list = new LinkedList();
            for (String val : values = value.split(",")) {
                list.add(Injection.createObjectFromString(type.getComponentType(), null, val, annotations));
            }
            return (T)list.toArray(ArrayUtil.createGenericArrayOf((int)list.size(), type.getComponentType()));
        }
        try {
            return (T)StringParser.parse(type, (String)value);
        }
        catch (Exception e) {
            throw new InjectionException("Cannot convert string " + value + " into type " + type.getName(), e);
        }
    }

    public static void injectAttribute(InjectionContext ctx, Object instance, ObjectAttribute attribute) throws InjectionException {
        String name = attribute.getName();
        Class<?> cl = instance.getClass();
        Method setter = ClassUtil.getSetter(cl, (String)name);
        if (setter != null) {
            Object o = attribute.getValue().create(ctx, setter.getParameterTypes()[0], setter.getGenericParameterTypes()[0], setter.getAnnotations());
            if (o != null) {
                try {
                    setter.invoke(instance, o);
                }
                catch (IllegalAccessException e) {
                    throw new InjectionException("Cannot call setter of attribute " + name + " on class " + cl.getName());
                }
                catch (InvocationTargetException e) {
                    throw new InjectionException("Error while calling the setter for attribute " + name + " on class " + cl.getName(), e);
                }
            }
            return;
        }
        Field f = ClassUtil.getField(cl, (String)name);
        if (f != null) {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            Object o = attribute.getValue().create(ctx, f.getType(), f.getGenericType(), f.getAnnotations());
            try {
                f.set(instance, o);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access to attribute " + name + " on class " + cl.getName());
            }
            return;
        }
        throw new InjectionException("Unknown attribute " + name + " on class " + cl.getName());
    }

    public static void inject(InjectionContext ctx, Object instance) throws InjectionException {
        Class<?> cl = instance.getClass();
        for (Field f : ClassUtil.getAllFields(cl)) {
            Inject i = f.getAnnotation(Inject.class);
            if (i == null) continue;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            try {
                if (f.get(instance) != null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access to field " + f.getName() + " in class " + cl.getName());
            }
            Object o = i.id().length() > 0 ? ctx.getObjectById(i.id(), f.getType()) : ctx.getObject(f.getType());
            if (o == null && i.required()) {
                throw new InjectionException("Unable to inject field " + f.getName() + " in class " + cl.getName());
            }
            if (o == null) continue;
            try {
                f.set(instance, o);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access to field " + f.getName() + " in class " + cl.getName());
            }
        }
    }

    public static void call(InjectionContext ctx, Object instance, ObjectMethod method) throws Exception {
        Method m = ClassUtil.getMethod(instance.getClass(), (String)method.getName(), (int)method.getParameters().size());
        if (m == null) {
            return;
        }
        Class<?>[] types = m.getParameterTypes();
        Object[] objects = new Object[types.length];
        Type[] genericTypes = m.getGenericParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        for (int i = 0; i < types.length; ++i) {
            objects[i] = method.getParameters().get(i).create(ctx, types[i], genericTypes[i], annotations[i]);
        }
        m.invoke(instance, objects);
    }

    public static String resolveProperties(InjectionContext ctx, Application app, String value) {
        int j;
        int i;
        if (value == null) {
            return null;
        }
        int pos = 0;
        while ((i = value.indexOf("${", pos)) >= 0 && (j = value.indexOf(125, i + 2)) >= 0) {
            String name = value.substring(i + 2, j);
            String s = ctx.getProperty(name);
            if (s == null) {
                s = app.getProperty(name);
            }
            if (s != null) {
                value = value.substring(0, i) + s + value.substring(j + 1);
                pos = i + s.length();
                continue;
            }
            pos = j + 1;
        }
        return value;
    }

    public static String resolveProperties(InjectionContext ctx, Application app, CharSequence value) {
        if (value == null) {
            return null;
        }
        return Injection.resolveProperties(ctx, app, value.toString());
    }

    public static void scanPackage(InjectionContext ctx, Application app, String pkgName, boolean singletons) throws Exception {
        Logger logger = app.getLoggerFactory().getLogger(Injection.class);
        if (logger.debug()) {
            logger.debug("Scanning package " + pkgName);
        }
        StringBuilder errors = new StringBuilder();
        app.getLibrariesManager().scanLibraries(pkgName, false, null, null, cl -> {
            try {
                Injection.scanClass(ctx, app, singletons, cl, logger);
            }
            catch (Exception e) {
                errors.append(e.getMessage()).append("\r\n");
            }
        });
        if (errors.length() > 0) {
            throw new Exception(errors.toString());
        }
    }

    private static void scanClass(final InjectionContext ctx, Application app, boolean singleton, final Class<?> cl, Logger logger) throws Exception {
        InjectableWhen when;
        if (logger.debug()) {
            logger.debug("Scan class " + cl.getName());
        }
        if ((when = cl.getAnnotation(InjectableWhen.class)) != null) {
            for (Property p : when.value()) {
                String name = p.name();
                String value = p.value();
                if ((value = Injection.resolveProperties(ctx, app, value)).equals(app.getProperty(name))) continue;
                return;
            }
        }
        Class<?> type = null;
        String id = "";
        Injectable it = cl.getAnnotation(Injectable.class);
        if (it != null) {
            type = it.value();
            singleton = it.singleton();
            id = it.id();
        } else {
            Class<?>[] interfaces = cl.getInterfaces();
            Class<?> superClass = cl.getSuperclass();
            if (interfaces.length == 1) {
                type = interfaces[0];
            } else if (superClass != null) {
                type = superClass;
            } else {
                return;
            }
        }
        if (logger.debug()) {
            logger.debug("Injectable class found: " + cl.getName());
        }
        if (singleton) {
            ctx.add(new SingletonOnDemand(ctx, type, new Provider<Object>(){

                public Object provide() {
                    try {
                        return Injection.create(ctx, cl, null, new ArrayList<ObjectAttribute>(0));
                    }
                    catch (InjectionException e) {
                        throw new RuntimeException("Unable to create singleton to be injected", e);
                    }
                }
            }, id.length() > 0 ? id : null, null));
        } else {
            ctx.add(new Factory(ctx, type, cl, null, new ArrayList<ObjectAttribute>(0), id.length() > 0 ? id : null));
        }
    }
}

