/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import net.lecousin.framework.injection.Injection;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.util.ClassUtil;

public class ObjectAttribute {
    protected String name;
    protected String value;
    protected String ref;
    protected String fromId;
    protected String fromAttribute;
    protected Class<?> clazz;
    protected List<String> parameters;
    protected List<ObjectAttribute> attributes;

    public ObjectAttribute(String name, String value, String ref, String fromId, String fromAttribute) {
        this.name = name;
        this.value = value;
        this.ref = ref;
        this.fromId = fromId;
        this.fromAttribute = fromAttribute;
    }

    public ObjectAttribute(String name, Class<?> clazz, List<String> parameters, List<ObjectAttribute> attributes) {
        this.name = name;
        this.clazz = clazz;
        this.parameters = parameters;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExplicitlyNull() {
        return "null".equals(this.value);
    }

    public Object create(InjectionContext ctx, Class<?> type, Type genericType, Annotation[] annotations) throws InjectionException {
        if (this.value != null) {
            return Injection.createObjectFromString(type, genericType, this.value, annotations);
        }
        if (this.ref != null) {
            return ctx.getObjectById(this.ref, type);
        }
        if (this.fromId != null) {
            Object o = ctx.getObjectById(this.fromId);
            if (o == null) {
                return null;
            }
            Class<?> cl = o.getClass();
            Field f = ClassUtil.getField(cl, (String)this.fromAttribute);
            if (f != null) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                try {
                    return f.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new InjectionException("Cannot access to attribute " + this.fromAttribute + " on class " + cl.getName());
                }
            }
            Method getter = ClassUtil.getGetter(cl, (String)this.fromAttribute);
            if (getter != null && (getter.getModifiers() & 1) != 0) {
                try {
                    return getter.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new InjectionException("Cannot access to attribute " + this.fromAttribute + " on class " + cl.getName());
                }
                catch (InvocationTargetException e) {
                    throw new InjectionException("Error while accessing to attribute " + this.fromAttribute + " on class " + cl.getName(), e);
                }
            }
        }
        return Injection.create(ctx, this.clazz, this.parameters, null, this.attributes);
    }
}

