/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.injection.Factory;
import net.lecousin.framework.injection.Injectable;
import net.lecousin.framework.injection.InjectableWhen;
import net.lecousin.framework.injection.Injection;
import net.lecousin.framework.injection.InjectionContext;
import net.lecousin.framework.injection.ObjectAttribute;
import net.lecousin.framework.injection.ObjectMethod;
import net.lecousin.framework.injection.Singleton;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;
import net.lecousin.framework.properties.Property;
import net.lecousin.framework.util.ClassUtil;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public final class InjectionXmlConfiguration {
    public static final String NAMESPACE_URI_0_1 = "http://code.lecousin.net/java/net.lecousin.framework.injection/0.1";

    private InjectionXmlConfiguration() {
    }

    public static ISynchronizationPoint<Exception> configure(InjectionContext ctx, String filename) {
        ClassLoader cl = LCCore.getApplication().getClassLoader();
        IOProviderFromPathUsingClassloader iop = new IOProviderFromPathUsingClassloader(cl);
        IOProvider.Readable provider = iop.get(filename);
        if (provider == null) {
            return new SynchronizationPoint((Exception)new FileNotFoundException(filename));
        }
        try {
            return InjectionXmlConfiguration.configure(ctx, provider.provideIOReadable((byte)3));
        }
        catch (IOException e) {
            return new SynchronizationPoint((Exception)e);
        }
    }

    public static ISynchronizationPoint<Exception> configure(final InjectionContext ctx, final IO.Readable xml) {
        Object bio = xml instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)xml : new PreBufferedReadable(xml, 16384, 3, 16384, 4, 4);
        final SynchronizationPoint result = new SynchronizationPoint();
        XMLStreamReader.start((IO.Readable.Buffered)bio, (int)15000).listenInline(reader -> new Task.Cpu<Void, NoException>("Parsing Injection XML file", 4){

            public Void run() {
                try {
                    InjectionXmlConfiguration.configure(ctx, reader);
                    result.unblock();
                }
                catch (Exception e) {
                    result.error(e);
                }
                finally {
                    xml.closeAsync();
                }
                return null;
            }
        }.start(), error -> {
            xml.closeAsync();
            result.error(error);
        }, cancel -> {
            xml.closeAsync();
            result.cancel(cancel);
        });
        return result;
    }

    private static void configure(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
            try {
                xml.next();
            }
            catch (EOFException e) {
                throw new Exception("Invalid XML: no root element");
            }
        }
        InjectionXmlConfiguration.configureInjection(ctx, xml);
    }

    public static void configureInjection(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        if (!xml.event.localName.equals((CharSequence)"Injection")) {
            throw new Exception("Invalid XML: root element must be Injection");
        }
        if (!xml.event.namespaceURI.equals((CharSequence)NAMESPACE_URI_0_1)) {
            throw new Exception("Unknown injection namespace: " + xml.event.namespaceURI);
        }
        InjectionXmlConfiguration.configureInjection01(ctx, xml);
    }

    private static void configureInjection01(InjectionContext ctx, XMLStreamReader xml) throws Exception {
        Application app = LCCore.getApplication();
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.text.equals((CharSequence)"Singleton")) {
                InjectionXmlConfiguration.configureObjectProvider01(ctx, app, xml, true);
                continue;
            }
            if (xml.event.text.equals((CharSequence)"Factory")) {
                InjectionXmlConfiguration.configureObjectProvider01(ctx, app, xml, false);
                continue;
            }
            if (xml.event.text.equals((CharSequence)"property")) {
                InjectionXmlConfiguration.configureProperty01(ctx, app, xml);
                continue;
            }
            if (xml.event.text.equals((CharSequence)"scan-package")) {
                InjectionXmlConfiguration.configureScanPackage01(ctx, app, xml);
                continue;
            }
            if (xml.event.text.equals((CharSequence)"import")) {
                InjectionXmlConfiguration.configureImport01(ctx, app, xml);
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString() + " in Injection");
        }
    }

    private static void configureProperty01(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing name of property");
        }
        UnprotectedStringBuffer value = xml.getAttributeValueByLocalName((CharSequence)"value");
        if (value == null) {
            throw new Exception("Missing value of property");
        }
        String val = Injection.resolveProperties(ctx, app, value.asString());
        ctx.setProperty(name.asString(), val);
        if (!xml.event.isClosed) {
            xml.closeElement();
        }
    }

    private static void configureObjectProvider01(InjectionContext ctx, Application app, XMLStreamReader xml, boolean isSingleton) throws Exception {
        UnprotectedStringBuffer id = xml.getAttributeValueByLocalName((CharSequence)"id");
        String typeStr = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"type"));
        Class<?> type = typeStr != null ? app.getClassLoader().loadClass(typeStr) : null;
        Class<?> cl = null;
        LinkedList<ObjectAttribute> attributes = null;
        ObjectMethod initMethod = null;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.text.equals((CharSequence)"class")) {
                UnprotectedStringBuffer n = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (n == null) {
                    throw new Exception("Missing attribute name on element class");
                }
                String name = Injection.resolveProperties(ctx, app, n.asString());
                boolean eligible = true;
                LinkedList<ObjectAttribute> attrs = new LinkedList<ObjectAttribute>();
                ObjectMethod init = null;
                XMLStreamEvents.ElementContext elemClass = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                while (xml.nextInnerElement(elemClass)) {
                    if (xml.event.text.equals((CharSequence)"property")) {
                        UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                        if (pname == null) {
                            throw new Exception("Missing attribute name on element property");
                        }
                        Property[] pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                        if (pvalue == null) {
                            throw new Exception("Missing attribute value on property " + pname);
                        }
                        eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"attribute")) {
                        attrs.add(InjectionXmlConfiguration.readObjectAttribute01(ctx, xml, app));
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"init-method")) {
                        if (init != null) {
                            throw new Exception("Only one init-method can be specified for class " + name);
                        }
                        init = InjectionXmlConfiguration.readObjectMethod01(xml);
                        continue;
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString());
                }
                if (!eligible) continue;
                try {
                    cl = app.getClassLoader().loadClass(name);
                }
                catch (Throwable t) {
                    continue;
                }
                InjectableWhen when = cl.getAnnotation(InjectableWhen.class);
                if (when != null) {
                    for (Property p : when.value()) {
                        String pname = p.name();
                        String pvalue = p.value();
                        if ((pvalue = Injection.resolveProperties(ctx, app, pvalue)).equals(Injection.getProperty(app, ctx, pname))) continue;
                        eligible = false;
                        break;
                    }
                }
                if (!eligible) continue;
                if (type == null) {
                    Injectable it = cl.getAnnotation(Injectable.class);
                    type = it == null ? cl : it.value();
                }
                if (init != null) {
                    List list = ClassUtil.getMethods(cl, (String)init.getName(), (int)init.getParameters().size());
                    if (list.isEmpty()) {
                        throw new Exception("Init method " + init.getName() + " does not exist on class " + cl.getName());
                    }
                    if (list.size() > 1) {
                        throw new Exception("Init method " + init.getName() + " is ambiguous on class " + cl.getName());
                    }
                }
                initMethod = init;
                attributes = attrs;
                break;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (cl == null || type == null) {
            return;
        }
        if (isSingleton) {
            ctx.add(new Singleton(type, Injection.create(ctx, cl, initMethod, attributes), id != null ? id.asString() : null));
        } else {
            ctx.add(new Factory(type, cl, initMethod, attributes, id != null ? id.asString() : null));
        }
    }

    private static void configureScanPackage01(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        String pkgName = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"package"));
        if (pkgName == null) {
            throw new Exception("Missing package attribute on element scan-package");
        }
        boolean singletons = true;
        UnprotectedStringBuffer s = xml.getAttributeValueByLocalName((CharSequence)"singleton");
        if (s != null && s.toLowerCase().equals((CharSequence)"false")) {
            singletons = false;
        }
        boolean eligible = true;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.text.equals((CharSequence)"property")) {
                UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (pname == null) {
                    throw new Exception("Missing attribute name on element property");
                }
                String pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                if (pvalue == null) {
                    throw new Exception("Missing attribute value on property " + pname);
                }
                eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (!eligible) {
            return;
        }
        Injection.scanPackage(ctx, app, pkgName, singletons);
    }

    private static void configureImport01(InjectionContext ctx, Application app, XMLStreamReader xml) throws Exception {
        String filename = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"file"));
        if (filename == null) {
            throw new Exception("Missing file attribute on element import");
        }
        boolean eligible = true;
        XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
        while (xml.nextInnerElement(elem)) {
            if (xml.event.text.equals((CharSequence)"property")) {
                UnprotectedStringBuffer pname = xml.getAttributeValueByLocalName((CharSequence)"name");
                if (pname == null) {
                    throw new Exception("Missing attribute name on element property");
                }
                String pvalue = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
                if (pvalue == null) {
                    throw new Exception("Missing attribute value on property " + pname);
                }
                eligible &= pvalue.equals(Injection.getProperty(app, ctx, pname.asString()));
                continue;
            }
            throw new Exception("Unexpected element " + xml.event.text.asString());
        }
        if (!eligible) {
            return;
        }
        InjectionXmlConfiguration.configure(ctx, filename).blockThrow(0L);
    }

    public static ObjectAttribute readObjectAttribute01(InjectionContext ctx, XMLStreamReader xml, Application app) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing attribute name on element 'attribute'");
        }
        String value = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"value"));
        String ref = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"ref"));
        String clazz = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"class"));
        String fromSingleton = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"fromSingleton"));
        if (value != null) {
            if (ref != null) {
                throw new Exception("Attributes value and ref are exclusive on element 'attribute'");
            }
            if (clazz != null) {
                throw new Exception("Attributes value and class are exclusive on element 'attribute'");
            }
            if (fromSingleton != null) {
                throw new Exception("Attributes value and fromSingleton are exclusive on element 'attribute'");
            }
            if (!xml.event.isClosed) {
                xml.closeElement();
            }
            return new ObjectAttribute(name.asString(), value, null, null, null);
        }
        if (ref != null) {
            if (clazz != null) {
                throw new Exception("Attributes ref and class are exclusive on element 'attribute'");
            }
            if (fromSingleton != null) {
                throw new Exception("Attributes ref and fromSingleton are exclusive on element 'attribute'");
            }
            if (!xml.event.isClosed) {
                xml.closeElement();
            }
            return new ObjectAttribute(name.asString(), null, ref, null, null);
        }
        if (clazz != null) {
            if (fromSingleton != null) {
                throw new Exception("Attributes class and fromSingleton are exclusive on element 'attribute'");
            }
            Class<?> cl = app.getClassLoader().loadClass(clazz);
            LinkedList<String> params = new LinkedList<String>();
            LinkedList<ObjectAttribute> attrs = new LinkedList<ObjectAttribute>();
            if (!xml.event.isClosed) {
                XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                while (xml.nextInnerElement(elem)) {
                    if (xml.event.text.equals((CharSequence)"parameter")) {
                        UnprotectedStringBuffer val = xml.getAttributeValueByLocalName((CharSequence)"value");
                        if (val == null) {
                            throw new Exception("Missing attribute value on element parameter");
                        }
                        params.add(Injection.resolveProperties(ctx, app, val.asString()));
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"attribute")) {
                        attrs.add(InjectionXmlConfiguration.readObjectAttribute01(ctx, xml, app));
                        continue;
                    }
                    throw new Exception("Unexpected element " + xml.event.text.asString());
                }
            }
            return new ObjectAttribute(name.asString(), cl, params, attrs);
        }
        String fromAttr = Injection.resolveProperties(ctx, app, (CharSequence)xml.getAttributeValueByLocalName((CharSequence)"fromAttribute"));
        if (fromAttr == null) {
            throw new Exception("Missing fromAttribute with fromSingleton on element 'attribute'");
        }
        return new ObjectAttribute(name.asString(), null, null, fromSingleton, fromAttr);
    }

    public static ObjectMethod readObjectMethod01(XMLStreamReader xml) throws Exception {
        UnprotectedStringBuffer name = xml.getAttributeValueByLocalName((CharSequence)"name");
        if (name == null) {
            throw new Exception("Missing attribute name on element '" + xml.event.text.asString() + "'");
        }
        LinkedList<String> params = new LinkedList<String>();
        if (!xml.event.isClosed) {
            XMLStreamEvents.ElementContext elem = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
            while (xml.nextInnerElement(elem)) {
                if (xml.event.text.equals((CharSequence)"parameter")) {
                    UnprotectedStringBuffer val = xml.getAttributeValueByLocalName((CharSequence)"value");
                    if (val == null) {
                        throw new Exception("Missing attribute value on element parameter");
                    }
                    params.add(val.asString());
                    continue;
                }
                throw new Exception("Unexpected element " + xml.event.text.asString());
            }
        }
        return new ObjectMethod(name.asString(), params);
    }
}

