/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.injection;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.injection.InjectionException;
import net.lecousin.framework.injection.ObjectProvider;

public class InjectionContext {
    private InjectionContext parent;
    private Map<String, String> properties = new HashMap<String, String>();
    private LinkedArrayList<ObjectProvider> providers = new LinkedArrayList(10);
    private Map<String, ObjectProvider> providerById = new HashMap<String, ObjectProvider>();

    public InjectionContext(InjectionContext parent) {
        this.parent = parent;
    }

    public InjectionContext() {
        this(null);
    }

    public InjectionContext getParent() {
        return this.parent;
    }

    public void setParent(InjectionContext parent) {
        this.parent = parent;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        String value = this.properties.get(name);
        if (value == null && this.parent != null) {
            return this.parent.getProperty(name);
        }
        return value;
    }

    public Object getObjectById(String id) throws InjectionException {
        ObjectProvider provider = this.providerById.get(id);
        if (provider == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id);
        }
        return provider.provide(this);
    }

    public <T> T getObjectById(String id, Class<T> type) throws InjectionException {
        ObjectProvider provider = this.providerById.get(id);
        if (provider == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id, type);
        }
        if (!type.isAssignableFrom(provider.getType())) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getObjectById(id, type);
        }
        return (T)provider.provide(this);
    }

    public <T> T getObject(Class<T> type) throws InjectionException {
        for (ObjectProvider provider : this.providers) {
            if (!type.isAssignableFrom(provider.getType())) continue;
            return (T)provider.provide(this);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getObject(type);
    }

    public void add(ObjectProvider provider) throws InjectionException {
        String id = provider.getId();
        if (id != null) {
            if (this.providerById.containsKey(id)) {
                throw new InjectionException("Duplicate object provider with id " + id);
            }
            this.providerById.put(id, provider);
        }
        this.providers.add((Object)provider);
    }
}

