/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.application.libraries.LibraryManagementException;

public class MavenSettings {
    private String localRepository = null;
    private ArrayList<String> activeProfiles = new ArrayList();

    public String getLocalRepository() {
        return this.localRepository;
    }

    public List<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    public static MavenSettings load(File file) throws IOException, XMLStreamException, LibraryManagementException {
        try (FileInputStream input = new FileInputStream(file);){
            MavenSettings mavenSettings = MavenSettings.load(input);
            return mavenSettings;
        }
    }

    public static MavenSettings load(InputStream input) throws XMLStreamException, LibraryManagementException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XMLStreamReader xml = factory.createXMLStreamReader(input);
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            if (!"settings".equals(xml.getLocalName())) {
                throw new LibraryManagementException("Root element of a Maven settings.xml file must be <settings>");
            }
            return MavenSettings.readSettings(xml);
        }
        return new MavenSettings();
    }

    private static MavenSettings readSettings(XMLStreamReader xml) throws XMLStreamException {
        MavenSettings settings = new MavenSettings();
        block0: while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() == 1) {
                if ("localRepository".equals(xml.getLocalName())) {
                    settings.localRepository = xml.getElementText().trim();
                    continue;
                }
                if ("activeProfiles".equals(xml.getLocalName())) {
                    while (xml.hasNext()) {
                        xml.next();
                        if (xml.getEventType() == 1) {
                            if (!"activeProfile".equals(xml.getLocalName())) continue;
                            settings.activeProfiles.add(xml.getElementText().trim());
                            continue;
                        }
                        if (xml.getEventType() != 2) continue;
                        continue block0;
                    }
                    continue;
                }
                MavenSettings.skipElement(xml);
                continue;
            }
            if (xml.getEventType() != 2) continue;
        }
        settings.activeProfiles.trimToSize();
        return settings;
    }

    private static void skipElement(XMLStreamReader xml) throws XMLStreamException {
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() == 1) {
                MavenSettings.skipElement(xml);
                continue;
            }
            if (xml.getEventType() != 2) continue;
            break;
        }
    }
}

