/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.loader.maven.MavenPOM;
import net.lecousin.framework.application.loader.maven.MavenPOMException;
import net.lecousin.framework.application.loader.maven.MavenPOMLoader;
import net.lecousin.framework.application.loader.maven.MavenRepository;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.TemporaryFiles;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromURI;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public class MavenRemoteRepository
implements MavenRepository {
    private String url;
    private boolean releasesEnabled;
    private boolean snapshotsEnabled;
    private Logger logger;

    public MavenRemoteRepository(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.url = url;
        this.releasesEnabled = releasesEnabled;
        this.snapshotsEnabled = snapshotsEnabled;
        this.logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenRemoteRepository.class);
    }

    @Override
    public boolean isReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Override
    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Override
    public boolean isSame(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        return releasesEnabled == this.releasesEnabled && snapshotsEnabled == this.snapshotsEnabled && url.equals(this.url);
    }

    private IO.Readable download(String path, Task.Priority priority) {
        IO.Readable io;
        if (this.logger.info()) {
            this.logger.info("Downloading " + this.url + path);
        }
        try {
            IOProvider p = IOProviderFromURI.getInstance().get(new URI(this.url + path));
            if (!(p instanceof IOProvider.Readable)) {
                return null;
            }
            io = ((IOProvider.Readable)p).provideIOReadable(priority);
        }
        catch (Exception e) {
            if (this.logger.error()) {
                this.logger.error("Unable to get IOProvider for " + this.url + path, (Throwable)e);
            }
            return null;
        }
        return io;
    }

    @Override
    public AsyncSupplier<List<String>, NoException> getAvailableVersions(String groupId, String artifactId, Task.Priority priority) {
        String path = groupId.replace('.', '/') + '/' + artifactId + "/maven-metadata.xml";
        IO.Readable io = this.download(path, priority);
        if (io == null) {
            return new AsyncSupplier(null, null);
        }
        Object bio = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 8192);
        AsyncSupplier start = XMLStreamReader.start((IO.Readable.Buffered)bio, (int)5000, (int)4, (boolean)false);
        AsyncSupplier result = new AsyncSupplier();
        start.thenStart(Task.cpu((String)"Read maven-metadata.xml", (Task.Priority)priority, t -> {
            try {
                XMLStreamReader xml = (XMLStreamReader)start.getResult();
                while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
                    xml.next();
                }
                if (!xml.goInto((XMLStreamEvents.ElementContext)xml.event.context.getFirst(), new String[]{"versioning", "versions"})) {
                    if (this.logger.error()) {
                        this.logger.error(this.url + path + " does not contain element versioning/versions");
                    }
                    result.unblockSuccess(null);
                    return null;
                }
                XMLStreamEvents.ElementContext parent = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                LinkedList<String> versions = new LinkedList<String>();
                while (xml.nextInnerElement(parent, "version")) {
                    versions.add(xml.readInnerText().asString());
                }
                result.unblockSuccess(versions);
            }
            catch (Exception e) {
                if (this.logger.error()) {
                    this.logger.error("Error parsing " + this.url + path, (Throwable)e);
                }
                result.unblockSuccess(null);
            }
            return null;
        }), () -> {
            if (this.logger.error()) {
                this.logger.error("Error loading " + this.url + path, (Throwable)start.getError());
            }
            result.unblockSuccess(null);
        });
        io.closeAfter((IAsync)result);
        return result;
    }

    @Override
    public AsyncSupplier<MavenPOM, LibraryManagementException> load(String groupId, String artifactId, String version, MavenPOMLoader pomLoader, Task.Priority priority) {
        String path = groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + ".pom";
        if (this.logger.info()) {
            this.logger.info("Downloading " + this.url + path);
        }
        try {
            return pomLoader.loadPOM(new URI(this.url + path), true, priority);
        }
        catch (Exception e) {
            return new AsyncSupplier(null, (Exception)((Object)new MavenPOMException("Error loading POM file " + this.url + path, (Throwable)e)));
        }
    }

    public File loadFileSync(String groupId, String artifactId, String version, String classifier, String type) {
        try {
            return (File)this.loadFile(groupId, artifactId, version, classifier, type, Task.Priority.IMPORTANT).blockResult(0L);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AsyncSupplier<File, IOException> loadFile(String groupId, String artifactId, String version, String classifier, String type, Task.Priority priority) {
        String path = groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + MavenPOM.getFilename(artifactId, version, classifier, type);
        IO.Readable io = this.download(path, priority);
        if (io == null) {
            return new AsyncSupplier(null, null);
        }
        AsyncSupplier file = TemporaryFiles.get().createFileAsync("remote-maven", ".downloaded");
        AsyncSupplier result = new AsyncSupplier();
        file.thenDoOrStart("Download file from maven", priority, f -> {
            FileIO.WriteOnly out = new FileIO.WriteOnly(f, priority);
            IOUtil.copy((IO.Readable)io, (IO.Writable)out, (long)-1L, (boolean)true, null, (long)0L).onDone(() -> result.unblockSuccess(f), (IAsync)result);
        }, (IAsync)result);
        result.onErrorOrCancel(() -> ((IO.Readable)io).closeAsync());
        return result;
    }

    public String toString() {
        return "remote maven repository (" + this.url + ")";
    }
}

