/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.loader.maven.MavenLocalRepository;
import net.lecousin.framework.application.loader.maven.MavenPOM;
import net.lecousin.framework.application.loader.maven.MavenPOMException;
import net.lecousin.framework.application.loader.maven.MavenRemoteRepository;
import net.lecousin.framework.application.loader.maven.MavenRepository;
import net.lecousin.framework.collections.Tree;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.log.Logger;

public class MavenPOMLoader
implements LibraryDescriptorLoader {
    private static Logger logger = null;
    private Map<String, Map<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>>> loadingByName = new HashMap<String, Map<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>>>();
    private Map<URI, AsyncSupplier<MavenPOM, LibraryManagementException>> loadingByLocation = new HashMap<URI, AsyncSupplier<MavenPOM, LibraryManagementException>>();
    private List<MavenRepository> repositories = new LinkedList<MavenRepository>();
    private List<MavenRepository> knownRepositories = new LinkedList<MavenRepository>();

    public boolean detect(File dir) {
        return new File(dir, "pom.xml").exists();
    }

    public AsyncSupplier<? extends LibraryDescriptor, LibraryManagementException> loadProject(File dir, Task.Priority priority) {
        URI pomFile = new File(dir, "pom.xml").toURI();
        try {
            return this.loadPOM(pomFile, false, priority);
        }
        catch (Exception e) {
            return new AsyncSupplier(null, (Exception)((Object)new MavenPOMException(pomFile, (Throwable)e)));
        }
    }

    public synchronized AsyncSupplier<MavenPOM, LibraryManagementException> loadPOM(URI pomFile, boolean fromRepository, Task.Priority priority) {
        AsyncSupplier result;
        if (logger == null) {
            logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenPOMLoader.class);
        }
        if ((result = this.loadingByLocation.get(pomFile = pomFile.normalize())) != null) {
            return result;
        }
        if (logger.debug()) {
            logger.debug("Loading POM " + pomFile.toString());
        }
        result = new AsyncSupplier();
        AsyncSupplier<MavenPOM, LibraryManagementException> loadPOM = MavenPOM.load(pomFile, priority, this, fromRepository);
        this.loadingByLocation.put(pomFile, (AsyncSupplier<MavenPOM, LibraryManagementException>)result);
        AsyncSupplier res = result;
        loadPOM.onDone(() -> {
            if (loadPOM.hasError()) {
                if (logger.error()) {
                    logger.error("Unable to load POM file", (Throwable)loadPOM.getError());
                }
                res.error(loadPOM.getError());
                return;
            }
            MavenPOM pom = (MavenPOM)loadPOM.getResult();
            if (pom != null) {
                if (logger.debug()) {
                    logger.debug("POM loaded: " + pom.getGroupId() + ':' + pom.getArtifactId() + ':' + pom.getVersionString());
                }
                MavenPOMLoader mavenPOMLoader = this;
                synchronized (mavenPOMLoader) {
                    AsyncSupplier<MavenPOM, LibraryManagementException> resu;
                    Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>> artifact;
                    Map<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>> group = this.loadingByName.get(pom.getGroupId());
                    if (group == null) {
                        group = new HashMap<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>>();
                        this.loadingByName.put(pom.getGroupId(), group);
                    }
                    if ((artifact = group.get(pom.getArtifactId())) == null) {
                        artifact = new HashMap<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>();
                        group.put(pom.getArtifactId(), artifact);
                    }
                    if ((resu = artifact.get(pom.getVersion())) == null) {
                        artifact.put(pom.getVersion(), (AsyncSupplier<MavenPOM, LibraryManagementException>)res);
                    }
                }
            }
            res.unblockSuccess((Object)pom);
        });
        return result;
    }

    public synchronized AsyncSupplier<MavenPOM, LibraryManagementException> loadLibrary(String groupId, String artifactId, VersionSpecification version, Task.Priority priority, List<LibrariesRepository> additionalRepositories) {
        Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>> artifact;
        if (logger == null) {
            logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenPOMLoader.class);
        }
        AbstractList repos = additionalRepositories.isEmpty() ? new ArrayList(this.repositories.size()) : new LinkedList();
        repos.addAll(this.repositories);
        for (LibrariesRepository repo : additionalRepositories) {
            if (!(repo instanceof MavenRepository)) continue;
            repos.add((MavenRepository)repo);
        }
        Map<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>> group = this.loadingByName.get(groupId);
        if (group == null) {
            group = new HashMap<String, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>>();
            this.loadingByName.put(groupId, group);
        }
        if ((artifact = group.get(artifactId)) == null) {
            artifact = new HashMap<Version, AsyncSupplier<MavenPOM, LibraryManagementException>>();
            group.put(artifactId, artifact);
        }
        AsyncSupplier<MavenPOM, LibraryManagementException> r = null;
        Version rv = null;
        for (Map.Entry<Version, AsyncSupplier<MavenPOM, LibraryManagementException>> e : artifact.entrySet()) {
            if (!version.isMatching(e.getKey()) || r != null && version.compare(rv, (Object)e.getKey()) >= 0) continue;
            r = e.getValue();
            rv = e.getKey();
        }
        if (r != null) {
            return r;
        }
        AsyncSupplier result = new AsyncSupplier();
        this.loadFromRepository(groupId, artifactId, version, priority, repos, 0, artifact, (AsyncSupplier<MavenPOM, LibraryManagementException>)result);
        return result;
    }

    private void loadFromRepository(String groupId, String artifactId, VersionSpecification version, Task.Priority priority, List<MavenRepository> repos, int repoIndex, Map<Version, AsyncSupplier<MavenPOM, LibraryManagementException>> artifact, AsyncSupplier<MavenPOM, LibraryManagementException> result) {
        if (repoIndex == repos.size()) {
            result.error((Exception)((Object)new LibraryManagementException("Artifact not found: " + Artifact.toString((String)groupId, (String)artifactId, (String)version.toString()))));
            return;
        }
        boolean debug = logger.debug();
        MavenRepository repo = repos.get(repoIndex);
        if (debug) {
            logger.debug("Search Maven artifact " + Artifact.toString((String)groupId, (String)artifactId, (String)version.toString()) + " in " + repo.toString());
        }
        repo.getAvailableVersions(groupId, artifactId, priority).thenStart("Search artifact", priority, versions -> {
            if (versions == null || versions.isEmpty()) {
                if (debug) {
                    logger.debug("No version found for artifact " + Artifact.toString((String)groupId, (String)artifactId, (String)version.toString()) + " in " + repo.toString());
                }
                this.loadFromRepository(groupId, artifactId, version, priority, repos, repoIndex + 1, artifact, result);
                return;
            }
            String bestVersionString = null;
            Version bestVersion = null;
            for (String s : versions) {
                Version v = new Version(s);
                if (!version.isMatching(v) || bestVersion != null && version.compare((Object)bestVersion, (Object)v) > 0) continue;
                bestVersion = v;
                bestVersionString = s;
            }
            if (bestVersion == null) {
                this.loadFromRepository(groupId, artifactId, version, priority, repos, repoIndex + 1, artifact, result);
                return;
            }
            if (debug) {
                logger.debug("Version " + bestVersionString + " found for artifact " + Artifact.toString((String)groupId, (String)artifactId, (String)version.toString()) + " in " + repo.toString());
            }
            artifact.put(bestVersion, result);
            AsyncSupplier<MavenPOM, LibraryManagementException> load = repo.load(groupId, artifactId, bestVersionString, this, priority);
            load.onDone(() -> {
                if (load.getResult() == null) {
                    result.error((Exception)((Object)new LibraryManagementException("Artifact not found: " + Artifact.toString((String)groupId, (String)artifactId, (String)version.toString()))));
                    return;
                }
                if (debug) {
                    logger.debug("Maven artifact " + Artifact.toString((String)groupId, (String)artifactId, (String)((MavenPOM)load.getResult()).getVersionString()) + " found in " + repo.toString());
                }
                result.unblockSuccess(load.getResult());
            });
        }, true);
    }

    public void addRepository(MavenRepository repo) {
        this.repositories.add(repo);
    }

    MavenRepository getRepository(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        for (MavenRepository repo : this.repositories) {
            if (!repo.isSame(url, releasesEnabled, snapshotsEnabled)) continue;
            return null;
        }
        for (MavenRepository repo : this.knownRepositories) {
            if (!repo.isSame(url, releasesEnabled, snapshotsEnabled)) continue;
            return repo;
        }
        if (url.startsWith("file:/")) {
            try {
                MavenLocalRepository local = new MavenLocalRepository(new File(new URI(url)), releasesEnabled, snapshotsEnabled);
                this.knownRepositories.add(local);
                return local;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        MavenRemoteRepository remote = new MavenRemoteRepository(url, releasesEnabled, snapshotsEnabled);
        this.knownRepositories.add(remote);
        return remote;
    }

    public Version resolveVersionConflict(String groupId, String artifactId, Map<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> artifactVersions) {
        Version bestVersion = null;
        int bestDepth = -1;
        for (Map.Entry<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> e : artifactVersions.entrySet()) {
            for (Tree.Node<LibraryDescriptorLoader.DependencyNode> node : e.getValue()) {
                int depth = 0;
                Tree.WithParent tree = ((Tree.WithParent)node.getSubNodes()).getParent();
                while (tree.getParent() != null) {
                    ++depth;
                    tree = tree.getParent();
                }
                if (bestVersion != null && depth >= bestDepth) continue;
                bestVersion = e.getKey();
                bestDepth = depth;
            }
        }
        return bestVersion;
    }
}

