/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionRange;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.loader.maven.MavenPOMException;
import net.lecousin.framework.application.loader.maven.MavenPOMLoader;
import net.lecousin.framework.application.loader.maven.MavenRepository;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromURI;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Runnables;
import net.lecousin.framework.util.SystemEnvironment;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public class MavenPOM
implements LibraryDescriptor {
    public static final String ELEMENT_ARTIFACT_ID = "artifactId";
    public static final String ELEMENT_GROUP_ID = "groupId";
    public static final String ELEMENT_VERSION = "version";
    public static final String ELEMENT_DEPENDENCIES = "dependencies";
    private static final String LOAD = "Load POM ";
    private MavenPOMLoader loader;
    private URI pomFile;
    private String artifactId;
    private String groupId;
    private String version;
    private String packaging;
    private String parentArtifactId;
    private String parentGroupId;
    private String parentVersion;
    private String parentRelativePath = "../pom.xml";
    private AsyncSupplier<MavenPOM, LibraryManagementException> parentLoading;
    private Build build = new Build();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<Dependency> dependencies = new LinkedList<Dependency>();
    private List<Dependency> dependencyManagement = new LinkedList<Dependency>();
    private List<Repository> repositories = new LinkedList<Repository>();
    private List<Profile> profiles = new LinkedList<Profile>();
    private File classesFile = null;

    public static AsyncSupplier<MavenPOM, LibraryManagementException> load(URI pomFile, Task.Priority priority, MavenPOMLoader pomLoader, boolean fromRepository) {
        IO.Readable fileIO;
        AsyncSupplier result = new AsyncSupplier();
        IOProvider p = IOProviderFromURI.getInstance().get(pomFile);
        if (p == null) {
            return new AsyncSupplier(null, (Exception)((Object)new MavenPOMException(pomFile, (Throwable)new FileNotFoundException(pomFile.toString()))));
        }
        if (!(p instanceof IOProvider.Readable)) {
            return new AsyncSupplier(null, (Exception)((Object)new MavenPOMException(pomFile, "not readable")));
        }
        try {
            fileIO = ((IOProvider.Readable)p).provideIOReadable(priority);
        }
        catch (IOException e) {
            return new AsyncSupplier(null, (Exception)((Object)new MavenPOMException(pomFile, (Throwable)e)));
        }
        Task task = Task.cpu((String)(LOAD + pomFile), (Task.Priority)priority, t -> {
            AsyncSupplier readFile;
            int bufSize;
            if (fileIO instanceof IO.KnownSize) {
                try {
                    bufSize = (int)((IO.KnownSize)fileIO).getSizeSync();
                }
                catch (IOException e) {
                    result.error((Exception)((Object)new MavenPOMException(pomFile, (Throwable)e)));
                    return null;
                }
                byte[] buf = new byte[bufSize];
                readFile = new AsyncSupplier();
                fileIO.readFullyAsync(ByteBuffer.wrap(buf)).onDone(() -> readFile.unblockSuccess((Object)new ByteArrayIO(buf, pomFile.toString())), (IAsync)readFile);
            } else {
                bufSize = 4096;
                readFile = IOUtil.readFullyAsync((IO.Readable)fileIO, (int)4096);
            }
            MavenPOM pom = new MavenPOM(pomLoader, pomFile);
            readFile.thenStart(LOAD + pomFile, priority, taskCtx -> {
                fileIO.closeAsync();
                if (readFile.hasError()) {
                    result.error((Exception)((Object)new MavenPOMException(pomFile, (Throwable)readFile.getError())));
                    return null;
                }
                IO.Readable.Buffered bio = (IO.Readable.Buffered)readFile.getResult();
                AsyncSupplier startXMLReader = XMLStreamReader.start((IO.Readable.Buffered)bio, (int)bufSize, (int)3, (boolean)false);
                String string = LOAD + pomFile;
                MavenPOM mavenPOM = pom;
                mavenPOM.getClass();
                Task read = Task.cpu((String)string, (Task.Priority)priority, (Executable)mavenPOM.new Reader(startXMLReader, fromRepository, pomFile, pomLoader));
                read.startOn((IAsync)startXMLReader, true);
                read.getOutput().onDone(() -> {
                    if (pom.parentLoading == null) {
                        String string = "Finalize loading POM " + pomFile;
                        MavenPOM mavenPOM = pom;
                        mavenPOM.getClass();
                        Task.cpu((String)string, (Task.Priority)priority, (Executable)mavenPOM.new Finalize((AsyncSupplier<MavenPOM, LibraryManagementException>)result)).start();
                        return;
                    }
                    AsyncSupplier<MavenPOM, LibraryManagementException> asyncSupplier = pom.parentLoading;
                    String string = "Finalize loading POM " + pomFile;
                    MavenPOM mavenPOM = pom;
                    mavenPOM.getClass();
                    asyncSupplier.thenStart(string, priority, (Executable)mavenPOM.new Finalize((AsyncSupplier<MavenPOM, LibraryManagementException>)result), (IAsync)result);
                }, (IAsync)result);
                return null;
            }, true);
            return null;
        });
        task.startOn(fileIO.canStartReading(), true);
        return result;
    }

    private MavenPOM(MavenPOMLoader loader, URI pomFile) {
        this.loader = loader;
        this.pomFile = pomFile;
    }

    public List<LibrariesRepository> getDependenciesAdditionalRepositories() {
        return this.getRepositories(this.repositories);
    }

    private List<LibrariesRepository> getRepositories(List<Repository> repos) {
        ArrayList<LibrariesRepository> list = new ArrayList<LibrariesRepository>(repos.size());
        for (Repository r : repos) {
            MavenRepository repo;
            if (r.url == null || r.url.trim().isEmpty() || (repo = this.loader.getRepository(r.url, r.releasesEnabled, r.snapshotsEnabled)) == null) continue;
            list.add(repo);
        }
        return list;
    }

    public MavenPOMLoader getLoader() {
        return this.loader;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionString() {
        return this.version;
    }

    public Version getVersion() {
        return new Version(this.version);
    }

    public URI getDirectory() {
        try {
            return this.pomFile.resolve(".");
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasClasses() {
        return "jar".equals(this.packaging) || "bundle".equals(this.packaging);
    }

    public AsyncSupplier<File, NoException> getClasses() {
        if (!this.hasClasses()) {
            return new AsyncSupplier(null, null);
        }
        if (this.classesFile != null) {
            return new AsyncSupplier((Object)this.classesFile, null);
        }
        if ("file".equals(this.pomFile.getScheme())) {
            File pf = new File(this.pomFile);
            pf = pf.getParentFile();
            if (this.build.outputDirectory != null) {
                File dir = new File(this.build.outputDirectory);
                this.classesFile = dir.isAbsolute() ? dir : new File(pf, this.build.outputDirectory);
            } else {
                File f = new File(pf, this.artifactId + '-' + this.version + ".jar");
                if (f.exists()) {
                    this.classesFile = f;
                } else {
                    f = new File(pf, "target/classes");
                    if (f.exists()) {
                        this.classesFile = f;
                    }
                }
            }
            return new AsyncSupplier((Object)this.classesFile, null);
        }
        try {
            URI uri = this.pomFile.resolve(".").resolve(this.artifactId + '-' + this.version + ".jar");
            IOProvider p = IOProviderFromURI.getInstance().get(uri);
            if (!(p instanceof IOProvider.Readable)) {
                return new AsyncSupplier(null, null);
            }
            IO.Readable io = ((IOProvider.Readable)p).provideIOReadable(Task.Priority.IMPORTANT);
            if (io == null) {
                return new AsyncSupplier(null, null);
            }
            AsyncSupplier download = IOUtil.toTempFile((IO.Readable)io);
            AsyncSupplier result = new AsyncSupplier();
            download.onDone(() -> {
                if (download.isSuccessful()) {
                    this.classesFile = (File)download.getResult();
                    result.unblockSuccess((Object)this.classesFile);
                } else {
                    result.unblockSuccess(null);
                }
            });
            return result;
        }
        catch (Exception e) {
            return new AsyncSupplier(null, null);
        }
    }

    public List<LibraryDescriptor.Dependency> getDependencies() {
        ArrayList<LibraryDescriptor.Dependency> list = new ArrayList<LibraryDescriptor.Dependency>(this.dependencies.size());
        for (Dependency dep : this.dependencies) {
            if (dep.scope != null && !"compile".equals(dep.scope)) continue;
            list.add(dep);
        }
        return list;
    }

    public List<LibraryDescriptor.Dependency> getAllDependenciesAnyScope() {
        ArrayList<LibraryDescriptor.Dependency> list = new ArrayList<LibraryDescriptor.Dependency>(this.dependencies.size());
        list.addAll(this.dependencies);
        return list;
    }

    public static String getFilename(String artifactId, String version, String classifier, String type) {
        String cl = classifier == null || classifier.isEmpty() ? null : classifier;
        String extension = "jar";
        if (type != null) {
            switch (type) {
                case "test-jar": {
                    if (cl != null) break;
                    cl = "tests";
                    break;
                }
                case "maven-plugin": 
                case "ejb": {
                    break;
                }
                case "ejb-client": {
                    if (cl != null) break;
                    cl = "client";
                    break;
                }
                case "java-source": {
                    if (cl != null) break;
                    cl = "sources";
                    break;
                }
                case "javadoc": {
                    if (cl != null) break;
                    cl = "javadoc";
                    break;
                }
                default: {
                    extension = type;
                }
            }
        }
        StringBuilder name = new StringBuilder(100);
        name.append(artifactId).append('-').append(version);
        if (cl != null) {
            name.append('-').append(cl);
        }
        name.append('.').append(extension);
        return name.toString();
    }

    public String resolveProperty(String value) {
        return this.resolve(value, this.properties);
    }

    private String resolve(String value, Map<String, String> properties) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf("${");
        if (i < 0) {
            return value;
        }
        int j = value.indexOf(125, i + 2);
        if (j < 0) {
            return value;
        }
        String name = value.substring(i + 2, j).trim();
        if (properties.containsKey(name)) {
            StringBuilder s = new StringBuilder();
            if (i > 0) {
                s.append(value.substring(0, i));
            }
            s.append(properties.get(name));
            if (j < value.length() - 1) {
                s.append(value.substring(j + 1));
            }
            return this.resolve(s.toString(), properties);
        }
        if (name.equals("project.groupId")) {
            return this.groupId;
        }
        if (name.equals("project.artifactId")) {
            return this.artifactId;
        }
        if (name.equals("project.version")) {
            return this.version;
        }
        if (name.equals("parent.groupId")) {
            if (this.parentLoading != null) {
                return ((MavenPOM)this.parentLoading.getResult()).groupId;
            }
            return null;
        }
        if (name.equals("parent.artifactId")) {
            if (this.parentLoading != null) {
                return ((MavenPOM)this.parentLoading.getResult()).artifactId;
            }
            return null;
        }
        if (name.equals("parent.version")) {
            if (this.parentLoading != null) {
                return ((MavenPOM)this.parentLoading.getResult()).version;
            }
            return null;
        }
        if (name.startsWith("env.")) {
            return System.getenv(name.substring(4));
        }
        if (name.startsWith("settings.")) {
            return null;
        }
        return System.getProperty(name);
    }

    public static VersionSpecification parseVersionSpecification(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        char c = s.charAt(0);
        if (c == '[') {
            int i = s.indexOf(93);
            boolean excluded = false;
            if (i < 0 && (i = s.indexOf(41)) > 0) {
                excluded = true;
            }
            if (i < 0) {
                return new VersionSpecification.SingleVersion(new Version(s));
            }
            String range = s.substring(1, i).trim();
            if ((i = range.indexOf(44)) < 0) {
                return new VersionSpecification.SingleVersion(new Version(range));
            }
            Version min = new Version(range.substring(0, i).trim());
            Version max = (range = range.substring(i + 1).trim()).length() == 0 && excluded ? null : new Version(range);
            return new VersionSpecification.Range(new VersionRange(min, max, !excluded));
        }
        Version v = new Version(s);
        return new VersionSpecification.RangeWithRecommended(new VersionRange(v, null, false), v);
    }

    public String toString() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getVersionString();
    }

    private class Finalize
    implements Executable<Void, NoException> {
        private AsyncSupplier<MavenPOM, LibraryManagementException> finalResult;

        public Finalize(AsyncSupplier<MavenPOM, LibraryManagementException> result) {
            this.finalResult = result;
        }

        public Void execute(Task<Void, NoException> t) {
            HashMap<String, String> finalProperties = new HashMap<String, String>();
            if (MavenPOM.this.parentLoading != null) {
                if (MavenPOM.this.parentLoading.hasError()) {
                    this.finalResult.error((Exception)((Object)new MavenPOMException("Error loading parent POM", (Throwable)MavenPOM.this.parentLoading.getError())));
                    return null;
                }
                if (MavenPOM.this.parentLoading.isCancelled()) {
                    this.finalResult.cancel(MavenPOM.this.parentLoading.getCancelEvent());
                    return null;
                }
                this.inheritFromParent((MavenPOM)MavenPOM.this.parentLoading.getResult(), finalProperties);
            }
            this.resolveProperties(MavenPOM.this.properties, finalProperties);
            List<Profile> activeProfiles = this.getActiveProfiles(finalProperties);
            for (Profile p : activeProfiles) {
                this.addProfile(p);
            }
            this.resolveProperties(MavenPOM.this.properties, finalProperties);
            MavenPOM.this.properties = finalProperties;
            MavenPOM.this.groupId = MavenPOM.this.resolve(MavenPOM.this.groupId, finalProperties);
            MavenPOM.this.artifactId = MavenPOM.this.resolve(MavenPOM.this.artifactId, finalProperties);
            MavenPOM.this.version = MavenPOM.this.resolve(MavenPOM.this.version, finalProperties);
            if (MavenPOM.this.packaging == null) {
                MavenPOM.this.packaging = "jar";
            }
            MavenPOM.this.build.outputDirectory = MavenPOM.this.resolve(MavenPOM.this.build.outputDirectory, finalProperties);
            this.resolveDependencies(MavenPOM.this.dependencies, finalProperties);
            this.resolveDependencies(MavenPOM.this.dependencyManagement, finalProperties);
            this.resolveRepositories(MavenPOM.this.repositories, finalProperties);
            for (Dependency dep : MavenPOM.this.dependencies) {
                if (dep.groupId == null || dep.artifactId == null) continue;
                for (Dependency dm : MavenPOM.this.dependencyManagement) {
                    if (!dep.groupId.equals(dm.groupId) || !dep.artifactId.equals(dm.artifactId) || dm.version == null) continue;
                    dep.version = dm.version;
                }
            }
            this.finalResult.unblockSuccess((Object)MavenPOM.this);
            return null;
        }

        private void inheritFromParent(MavenPOM parent, Map<String, String> finalProperties) {
            if (MavenPOM.this.groupId == null) {
                MavenPOM.this.groupId = parent.groupId;
            }
            if (MavenPOM.this.version == null) {
                MavenPOM.this.version = parent.version;
            }
            for (Map.Entry p : parent.properties.entrySet()) {
                if (MavenPOM.this.properties.containsKey(p.getKey())) continue;
                finalProperties.put((String)p.getKey(), (String)p.getValue());
            }
            for (Dependency pdm : parent.dependencyManagement) {
                if (pdm.groupId == null || pdm.artifactId == null) continue;
                boolean found = false;
                for (Dependency dm : MavenPOM.this.dependencyManagement) {
                    if (dm.groupId == null || dm.artifactId == null || !dm.groupId.equals(pdm.groupId) || !dm.artifactId.equals(pdm.artifactId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                MavenPOM.this.dependencyManagement.add(pdm);
            }
        }

        private List<Profile> getActiveProfiles(Map<String, String> finalProperties) {
            LinkedList<Profile> defaultProfiles = new LinkedList<Profile>();
            LinkedList<Profile> activeProfiles = new LinkedList<Profile>();
            for (Profile profile : MavenPOM.this.profiles) {
                if (this.checkProfile(profile, finalProperties)) {
                    activeProfiles.add(profile);
                    continue;
                }
                if (!profile.activeByDefault) continue;
                defaultProfiles.add(profile);
            }
            if (!activeProfiles.isEmpty()) {
                return activeProfiles;
            }
            return defaultProfiles;
        }

        private boolean checkProfile(Profile profile, Map<String, String> finalProperties) {
            if (profile.activationOS != null && !this.checkProfileOS(profile.activationOS)) {
                return false;
            }
            if (profile.activationPropertyName != null && !this.checkProfileProperties(profile, finalProperties)) {
                return false;
            }
            if (profile.activationMissingFile != null) {
                // empty if block
            }
            if (profile.activationFileExists != null) {
                // empty if block
            }
            if (profile.jdk != null) {
                // empty if block
            }
            return true;
        }

        private boolean checkProfileOS(ActivationOS os) {
            if (os.family != null) {
                SystemEnvironment.OSFamily family = SystemEnvironment.getOSFamily();
                if (family == null) {
                    return false;
                }
                if (!this.checkProfileCondition(os.family.toLowerCase(), family.getName())) {
                    return false;
                }
            }
            return this.checkProfileCondition(os.name, System.getProperty("os.name")) && this.checkProfileCondition(os.arch, System.getProperty("os.arch")) && this.checkProfileCondition(os.version, System.getProperty("os.version"));
        }

        private boolean checkProfileProperties(Profile profile, Map<String, String> finalProperties) {
            if (profile.activationPropertyValue == null) {
                boolean presentExpected;
                String s = profile.activationPropertyName;
                boolean bl = presentExpected = !s.startsWith("!");
                if (!presentExpected) {
                    s = s.substring(1);
                }
                if (presentExpected != MavenPOM.this.properties.containsKey(s) && presentExpected != finalProperties.containsKey(s)) {
                    return false;
                }
            } else {
                boolean presentExpected;
                String p1 = (String)MavenPOM.this.properties.get(profile.activationPropertyName);
                String p2 = finalProperties.get(profile.activationPropertyName);
                String value = profile.activationPropertyName;
                boolean bl = presentExpected = !value.startsWith("!");
                if (!presentExpected) {
                    value = value.substring(1);
                }
                if (p1 == null || presentExpected != p1.equals(value)) {
                    if (p2 == null) {
                        return false;
                    }
                    if (presentExpected != p2.equals(value)) {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean checkProfileCondition(String condition, String value) {
            if (condition == null) {
                return true;
            }
            if (condition.startsWith("!")) {
                return !this.checkProfileCondition(condition.substring(1), value);
            }
            return value != null && value.equalsIgnoreCase(condition);
        }

        private void addProfile(Profile profile) {
            if (profile.build.outputDirectory != null) {
                MavenPOM.this.build.outputDirectory = profile.build.outputDirectory;
            }
            MavenPOM.this.properties.putAll(profile.properties);
            MavenPOM.this.dependencies.addAll(profile.dependencies);
            MavenPOM.this.dependencyManagement.addAll(profile.dependencyManagement);
            MavenPOM.this.repositories.addAll(profile.repositories);
        }

        private void resolveDependencies(List<Dependency> deps, Map<String, String> props) {
            for (Dependency dep : deps) {
                dep.groupId = MavenPOM.this.resolve(dep.groupId, props);
                dep.artifactId = MavenPOM.this.resolve(dep.artifactId, props);
                dep.version = MavenPOM.this.resolve(dep.version, props);
                dep.scope = MavenPOM.this.resolve(dep.scope, props);
                dep.type = MavenPOM.this.resolve(dep.type, props);
                dep.classifier = MavenPOM.this.resolve(dep.classifier, props);
                dep.systemPath = MavenPOM.this.resolve(dep.systemPath, props);
                for (Pair e : dep.exclusions) {
                    e.setValue1((Object)MavenPOM.this.resolve((String)e.getValue1(), props));
                    e.setValue2((Object)MavenPOM.this.resolve((String)e.getValue2(), props));
                }
            }
        }

        private void resolveRepositories(List<Repository> repos, Map<String, String> props) {
            for (Repository repo : repos) {
                repo.url = MavenPOM.this.resolve(repo.url, props);
            }
        }

        private void resolveProperties(Map<String, String> toResolve, Map<String, String> resolved) {
            while (!toResolve.isEmpty()) {
                boolean changed = false;
                Iterator<Map.Entry<String, String>> it = toResolve.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> p = it.next();
                    String value = MavenPOM.this.resolve(p.getValue(), resolved);
                    if (value == null) continue;
                    changed = true;
                    resolved.put(p.getKey(), value);
                    it.remove();
                }
                if (changed) continue;
                break;
            }
        }
    }

    private class Reader
    implements Executable<Void, LibraryManagementException> {
        private AsyncSupplier<XMLStreamReader, Exception> startXMLReader;
        private boolean fromRepository;
        private URI pomFile;
        private MavenPOMLoader pomLoader;

        private Reader(AsyncSupplier<XMLStreamReader, Exception> startXMLReader, boolean fromRepository, URI pomFile, MavenPOMLoader pomLoader) {
            this.startXMLReader = startXMLReader;
            this.fromRepository = fromRepository;
            this.pomFile = pomFile;
            this.pomLoader = pomLoader;
        }

        public Void execute(Task<Void, LibraryManagementException> taskContext) throws LibraryManagementException {
            if (this.startXMLReader.hasError()) {
                throw new MavenPOMException(this.pomFile, (Throwable)this.startXMLReader.getError());
            }
            if (this.startXMLReader.isCancelled()) {
                throw new MavenPOMException(this.pomFile, (Throwable)this.startXMLReader.getCancelEvent());
            }
            XMLStreamReader xml = (XMLStreamReader)this.startXMLReader.getResult();
            try {
                while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
                    xml.next();
                }
                if (!xml.event.text.equals((CharSequence)"project")) {
                    throw new MavenPOMException(this.pomFile, "Invalid POM: root element must be a project");
                }
                while (xml.nextStartElement()) {
                    if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_ARTIFACT_ID)) {
                        MavenPOM.this.artifactId = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_GROUP_ID)) {
                        MavenPOM.this.groupId = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_VERSION)) {
                        MavenPOM.this.version = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"packaging")) {
                        MavenPOM.this.packaging = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"parent")) {
                        this.readParent(xml);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"build")) {
                        this.readBuild(xml, MavenPOM.this.build);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"properties")) {
                        this.readProperties(xml, MavenPOM.this.properties);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"dependencyManagement")) {
                        this.readDependencyManagement(xml, MavenPOM.this.dependencyManagement);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_DEPENDENCIES)) {
                        this.readDependencies(xml, MavenPOM.this.dependencies);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"profiles")) {
                        this.readProfiles(xml);
                        continue;
                    }
                    if (xml.event.text.equals((CharSequence)"repositories")) {
                        this.readRepositories(xml, MavenPOM.this.repositories);
                        continue;
                    }
                    xml.closeElement();
                }
                if (MavenPOM.this.parentGroupId != null) {
                    File parentFile;
                    if (!this.fromRepository && (parentFile = new File(new File(this.pomFile).getParentFile(), MavenPOM.this.parentRelativePath)).exists()) {
                        if (parentFile.isDirectory()) {
                            if ((parentFile = new File(parentFile, "pom.xml")).exists()) {
                                MavenPOM.this.parentLoading = this.pomLoader.loadPOM(parentFile.toURI(), false, Task.getCurrentPriority());
                            }
                        } else {
                            MavenPOM.this.parentLoading = this.pomLoader.loadPOM(parentFile.toURI(), false, Task.getCurrentPriority());
                        }
                    }
                    if (MavenPOM.this.parentLoading == null) {
                        MavenPOM.this.parentLoading = this.pomLoader.loadLibrary(MavenPOM.this.parentGroupId, MavenPOM.this.parentArtifactId, (VersionSpecification)new VersionSpecification.SingleVersion(new Version(MavenPOM.this.parentVersion)), Task.getCurrentPriority(), MavenPOM.this.getRepositories(MavenPOM.this.repositories));
                    }
                }
                return null;
            }
            catch (LibraryManagementException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MavenPOMException(this.pomFile, (Throwable)e);
            }
        }

        private void readInnerElements(XMLStreamReader xml, Runnables.Throws<Exception> onInnerElement) throws MavenPOMException, XMLException, IOException {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (!XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) {
                        throw new MavenPOMException(this.pomFile, "Invalid POM: missing closing tag for " + ctx.text.toString());
                    }
                    return;
                }
                try {
                    onInnerElement.run();
                }
                catch (IOException | MavenPOMException | XMLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MavenPOMException("Error reading " + ctx.text.toString(), (Throwable)e);
                }
            }
        }

        private void readParent(XMLStreamReader xml) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_ARTIFACT_ID)) {
                    MavenPOM.this.parentArtifactId = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_GROUP_ID)) {
                    MavenPOM.this.parentGroupId = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_VERSION)) {
                    MavenPOM.this.parentVersion = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"relativePath")) {
                    MavenPOM.this.parentRelativePath = xml.readInnerText().trim().asString();
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readBuild(XMLStreamReader xml, Build build) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"outputDirectory")) {
                    build.outputDirectory = xml.readInnerText().trim().asString();
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readProperties(XMLStreamReader xml, Map<String, String> properties) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> properties.put(xml.event.text.asString(), xml.readInnerText().asString())));
        }

        private void readDependencyManagement(XMLStreamReader xml, List<Dependency> dependencyManagement) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_DEPENDENCIES)) {
                    this.readDependencies(xml, dependencyManagement);
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readDependencies(XMLStreamReader xml, List<Dependency> dependencies) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"dependency")) {
                    this.readDependency(xml, dependencies);
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readDependency(XMLStreamReader xml, List<Dependency> dependencies) throws MavenPOMException, XMLException, IOException {
            Dependency dep = new Dependency();
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_GROUP_ID)) {
                    dep.groupId = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_ARTIFACT_ID)) {
                    dep.artifactId = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_VERSION)) {
                    dep.version = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"type")) {
                    dep.type = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"classifier")) {
                    dep.classifier = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"scope")) {
                    dep.scope = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"systemPath")) {
                    dep.systemPath = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"optional")) {
                    dep.optional = xml.readInnerText().trim().equals((CharSequence)"true");
                } else if (xml.event.text.equals((CharSequence)"exclusions")) {
                    this.readExclusions(xml, dep.exclusions);
                } else {
                    xml.closeElement();
                }
            }));
            dependencies.add(dep);
        }

        private void readExclusions(XMLStreamReader xml, List<Pair<String, String>> exclusions) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"exclusion")) {
                    Pair e = new Pair(null, null);
                    XMLStreamEvents.ElementContext excluCtx = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
                    while (xml.nextInnerElement(excluCtx)) {
                        if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_GROUP_ID)) {
                            e.setValue1((Object)xml.readInnerText().trim().asString());
                            continue;
                        }
                        if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_ARTIFACT_ID)) {
                            e.setValue2((Object)xml.readInnerText().trim().asString());
                            continue;
                        }
                        xml.closeElement();
                    }
                    if ("*".equals(e.getValue1())) {
                        e.setValue1(null);
                    }
                    if ("*".equals(e.getValue2())) {
                        e.setValue2(null);
                    }
                    exclusions.add(e);
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readProfiles(XMLStreamReader xml) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"profile")) {
                    Profile profile = this.readProfile(xml);
                    if (profile != null) {
                        MavenPOM.this.profiles.add(profile);
                    }
                } else {
                    xml.closeElement();
                }
            }));
        }

        private Profile readProfile(XMLStreamReader xml) throws MavenPOMException, XMLException, IOException {
            Profile profile = new Profile();
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"activation")) {
                    this.readProfileActivation(xml, profile);
                } else if (xml.event.text.equals((CharSequence)"build")) {
                    this.readBuild(xml, profile.build);
                } else if (xml.event.text.equals((CharSequence)"properties")) {
                    this.readProperties(xml, profile.properties);
                } else if (xml.event.text.equals((CharSequence)"dependencyManagement")) {
                    this.readDependencyManagement(xml, profile.dependencyManagement);
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_DEPENDENCIES)) {
                    this.readDependencies(xml, profile.dependencies);
                } else if (xml.event.text.equals((CharSequence)"repositories")) {
                    this.readRepositories(xml, profile.repositories);
                } else {
                    xml.closeElement();
                }
            }));
            return profile;
        }

        private void readProfileActivation(XMLStreamReader xml, Profile profile) throws XMLException, IOException, MavenPOMException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"activeByDefault")) {
                    this.readProfileActivationActiveByDefault(xml, profile);
                } else if (xml.event.text.equals((CharSequence)"jdk")) {
                    profile.jdk = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"os")) {
                    this.readProfileActivationOS(xml, profile);
                } else if (xml.event.text.equals((CharSequence)"property")) {
                    this.readProfileActivationProperty(xml, profile);
                } else if (xml.event.text.equals((CharSequence)"file")) {
                    this.readProfileActivationFile(xml, profile);
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readProfileActivationActiveByDefault(XMLStreamReader xml, Profile profile) throws XMLException, IOException {
            if (xml.readInnerText().trim().equals((CharSequence)"true")) {
                profile.activeByDefault = true;
            }
        }

        private void readProfileActivationOS(XMLStreamReader xml, Profile profile) throws XMLException, IOException, MavenPOMException {
            profile.activationOS = new ActivationOS();
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"name")) {
                    profile.activationOS.name = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"family")) {
                    profile.activationOS.family = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"arch")) {
                    profile.activationOS.arch = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)MavenPOM.ELEMENT_VERSION)) {
                    profile.activationOS.version = xml.readInnerText().trim().asString();
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readProfileActivationProperty(XMLStreamReader xml, Profile profile) throws XMLException, IOException, MavenPOMException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"name")) {
                    profile.activationPropertyName = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"value")) {
                    profile.activationPropertyValue = xml.readInnerText().trim().asString();
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readProfileActivationFile(XMLStreamReader xml, Profile profile) throws XMLException, IOException, MavenPOMException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"missing")) {
                    profile.activationMissingFile = xml.readInnerText().trim().asString();
                } else if (xml.event.text.equals((CharSequence)"exists")) {
                    profile.activationFileExists = xml.readInnerText().trim().asString();
                } else {
                    xml.closeElement();
                }
            }));
        }

        private void readRepositories(XMLStreamReader xml, List<Repository> repositories) throws MavenPOMException, XMLException, IOException {
            this.readInnerElements(xml, (Runnables.Throws<Exception>)((Runnables.Throws)() -> {
                if (xml.event.text.equals((CharSequence)"repository")) {
                    Repository repo = this.readRepository(xml);
                    if (repo != null) {
                        repositories.add(repo);
                    }
                } else {
                    xml.closeElement();
                }
            }));
        }

        private Repository readRepository(XMLStreamReader xml) throws MavenPOMException, XMLException, IOException {
            if (xml.event.isClosed) {
                return null;
            }
            XMLStreamEvents.ElementContext ctx = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
            Repository repo = new Repository();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new MavenPOMException(this.pomFile, "Invalid POM: missing closing repository tag");
                }
                if (xml.event.text.equals((CharSequence)"id")) continue;
                if (xml.event.text.equals((CharSequence)"url")) {
                    repo.url = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals((CharSequence)"releases")) {
                    this.readRepositoryType(xml, repo, true);
                    continue;
                }
                if (xml.event.text.equals((CharSequence)"snapshots")) {
                    this.readRepositoryType(xml, repo, false);
                    continue;
                }
                xml.closeElement();
            }
            return repo;
        }

        private void readRepositoryType(XMLStreamReader xml, Repository repo, boolean isReleases) throws XMLException, MavenPOMException, IOException {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = (XMLStreamEvents.ElementContext)xml.event.context.getFirst();
            while (true) {
                String s;
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new MavenPOMException(this.pomFile, "Invalid POM: missing closing " + (isReleases ? "releases" : "snapshots") + " tag");
                }
                if (!xml.event.text.equals((CharSequence)"enabled") || !(s = xml.readInnerText().trim().asString()).equalsIgnoreCase("false")) continue;
                if (isReleases) {
                    repo.releasesEnabled = false;
                    continue;
                }
                repo.snapshotsEnabled = false;
            }
        }
    }

    private static class ActivationOS {
        private String name;
        private String family;
        private String arch;
        private String version;

        private ActivationOS() {
        }
    }

    private static class Profile {
        private boolean activeByDefault = false;
        private String jdk = null;
        private ActivationOS activationOS;
        private String activationPropertyName;
        private String activationPropertyValue;
        private String activationMissingFile;
        private String activationFileExists;
        private Build build = new Build();
        private Map<String, String> properties = new HashMap<String, String>();
        private List<Dependency> dependencyManagement = new LinkedList<Dependency>();
        private List<Dependency> dependencies = new LinkedList<Dependency>();
        private List<Repository> repositories = new LinkedList<Repository>();

        private Profile() {
        }
    }

    private static class Repository {
        private String url;
        private boolean releasesEnabled = true;
        private boolean snapshotsEnabled = true;

        private Repository() {
        }
    }

    public class Dependency
    implements LibraryDescriptor.Dependency {
        private String groupId;
        private String artifactId;
        private String version;
        private String type;
        private String classifier;
        private String scope;
        private String systemPath;
        private boolean optional = false;
        private List<Pair<String, String>> exclusions = new LinkedList<Pair<String, String>>();

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public VersionSpecification getVersionSpecification() {
            return MavenPOM.parseVersionSpecification(this.version);
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public URI getKnownLocation() {
            if (this.systemPath == null) {
                return null;
            }
            try {
                URI uri = new URI(this.systemPath);
                if (uri.isAbsolute()) {
                    return uri;
                }
                URI parent = MavenPOM.this.pomFile.resolve(".");
                return parent.resolve(this.systemPath);
            }
            catch (Exception e) {
                return null;
            }
        }

        public List<Pair<String, String>> getExcludedDependencies() {
            return this.exclusions;
        }
    }

    private static class Build {
        private String outputDirectory;

        private Build() {
        }
    }
}

