/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.loader.maven.MavenPOM;
import net.lecousin.framework.application.loader.maven.MavenPOMLoader;
import net.lecousin.framework.application.loader.maven.MavenRepository;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.exception.NoException;

public class MavenLocalRepository
implements MavenRepository {
    private File dir;
    private boolean releasesEnabled;
    private boolean snapshotsEnabled;

    public MavenLocalRepository(File dir, boolean releasesEnabled, boolean snapshotsEnabled) {
        this.dir = dir;
        this.releasesEnabled = releasesEnabled;
        this.snapshotsEnabled = snapshotsEnabled;
    }

    @Override
    public AsyncSupplier<List<String>, NoException> getAvailableVersions(String groupId, String artifactId, Task.Priority priority) {
        return Task.file((File)this.dir, (String)"Search artifact versions in local Maven repository", (Task.Priority)priority, t -> {
            File d = new File(this.dir, groupId.replace('.', '/'));
            if (!d.exists()) {
                return null;
            }
            if (!(d = new File(d, artifactId)).exists()) {
                return null;
            }
            File[] files = d.listFiles();
            if (files == null) {
                return null;
            }
            LinkedList<String> versions = new LinkedList<String>();
            for (File f : files) {
                File p;
                if (!f.isDirectory() || !(p = new File(f, artifactId + '-' + f.getName() + ".pom")).exists()) continue;
                versions.add(f.getName());
            }
            return versions;
        }).start().getOutput();
    }

    @Override
    public AsyncSupplier<MavenPOM, LibraryManagementException> load(String groupId, String artifactId, String version, MavenPOMLoader pomLoader, Task.Priority priority) {
        if (version.toLowerCase().endsWith("-SNAPSHOT") ? !this.snapshotsEnabled : !this.releasesEnabled) {
            return new AsyncSupplier(null, null);
        }
        AsyncSupplier result = new AsyncSupplier();
        Task.file((File)this.dir, (String)"Search Maven POM in local repository", (Task.Priority)priority, t -> {
            File pom;
            File d = new File(this.dir, groupId.replace('.', '/'));
            if (d.exists() && (d = new File(d, artifactId)).exists() && (d = new File(d, version)).exists() && (pom = new File(d, artifactId + '-' + version + ".pom")).exists()) {
                pomLoader.loadPOM(pom.toURI(), true, priority).forward(result);
                return null;
            }
            result.unblockSuccess(null);
            return null;
        }).start();
        return result;
    }

    public File loadFileSync(String groupId, String artifactId, String version, String classifier, String type) {
        File d = new File(this.dir, groupId.replace('.', '/'));
        if (!d.exists()) {
            return null;
        }
        if (!(d = new File(d, artifactId)).exists()) {
            return null;
        }
        if (!(d = new File(d, version)).exists()) {
            return null;
        }
        File file = new File(d, MavenPOM.getFilename(artifactId, version, classifier, type));
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public AsyncSupplier<File, IOException> loadFile(String groupId, String artifactId, String version, String classifier, String type, Task.Priority priority) {
        return Task.file((File)this.dir, (String)"Search file in Maven repository", (Task.Priority)priority, t -> this.loadFileSync(groupId, artifactId, version, classifier, type)).start().getOutput();
    }

    @Override
    public boolean isReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Override
    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Override
    public boolean isSame(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        if (releasesEnabled != this.releasesEnabled) {
            return false;
        }
        if (snapshotsEnabled != this.snapshotsEnabled) {
            return false;
        }
        try {
            URI uri = new URI(url);
            if (!"file".equals(uri.getScheme())) {
                return false;
            }
            if (!new File(uri).equals(this.dir)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "local maven repository (" + this.dir.getAbsolutePath() + ")";
    }
}

