/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.loader.maven;

import java.io.File;
import java.util.List;
import net.lecousin.framework.application.launcher.Launcher;
import net.lecousin.framework.application.launcher.LauncherService;
import net.lecousin.framework.application.loader.maven.MavenLocalRepository;
import net.lecousin.framework.application.loader.maven.MavenPOMLoader;
import net.lecousin.framework.application.loader.maven.MavenSettings;
import net.lecousin.framework.util.CommandLine;

public class LauncherUsingMaven
implements LauncherService {
    public static final String MAVEN_POM_LOADER_EXTENSION = "maven.pomLoader";

    public void addCommandLineArgumentsConsumers(List<CommandLine.ArgumentsConsumer<Launcher.CommandLineContext>> consumers) {
        consumers.add(new MavenRepositoryOptionConsumer());
    }

    public void printOptionsUsage() {
        System.out.println("[-maven-repository=<path>]*        Path to a Maven repository to look for");
        System.out.println("                                   artifacts. The option can be specified");
        System.out.println("                                   several times for several repositories");
    }

    public boolean checkCommandLineContext(Launcher.CommandLineContext context, List<String> errors) {
        File dir;
        if (!context.extensions.containsKey(MAVEN_POM_LOADER_EXTENSION)) {
            context.extensions.put(MAVEN_POM_LOADER_EXTENSION, new MavenPOMLoader());
        }
        MavenPOMLoader pomLoader = (MavenPOMLoader)context.extensions.get(MAVEN_POM_LOADER_EXTENSION);
        context.loaders.add(pomLoader);
        File settings = new File(System.getProperty("user.home") + "/.m2/settings.xml");
        String localRepo = System.getProperty("user.home") + "/.m2/repository";
        if (settings.exists()) {
            try {
                MavenSettings ms = MavenSettings.load(settings);
                if (ms.getLocalRepository() != null) {
                    localRepo = ms.getLocalRepository();
                }
            }
            catch (Exception e) {
                System.err.println("Error reading Maven settings.xml");
                e.printStackTrace(System.err);
            }
        }
        if ((dir = new File(localRepo)).exists()) {
            MavenLocalRepository repo = new MavenLocalRepository(dir, true, true);
            pomLoader.addRepository(repo);
            context.repositories.add(repo);
        }
        return true;
    }

    public void getSearchProjectsPaths(Launcher.CommandLineContext context, List<File> path) {
    }

    public boolean activeDebugMode(Launcher.CommandLineContext context) {
        return false;
    }

    private static class MavenRepositoryOptionConsumer
    implements CommandLine.ArgumentsConsumer<Launcher.CommandLineContext> {
        private MavenRepositoryOptionConsumer() {
        }

        public boolean matches(String arg, Launcher.CommandLineContext context) {
            return arg.startsWith("-maven-repository=");
        }

        public int consume(String[] args, int index, Launcher.CommandLineContext context) {
            String path = args[index].substring(18);
            File dir = new File(path);
            if (dir.exists()) {
                MavenLocalRepository repo = new MavenLocalRepository(dir, true, true);
                context.repositories.add(repo);
                MavenPOMLoader pomLoader = (MavenPOMLoader)context.extensions.get(LauncherUsingMaven.MAVEN_POM_LOADER_EXTENSION);
                if (pomLoader == null) {
                    pomLoader = new MavenPOMLoader();
                    context.extensions.put(LauncherUsingMaven.MAVEN_POM_LOADER_EXTENSION, pomLoader);
                }
                pomLoader.addRepository(repo);
            }
            return 1;
        }
    }
}

