/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectionHolder {
    private final Logger log = LoggerFactory.getLogger(ConnectionHolder.class);
    private final ConnectionFactory connectionFactory;
    private volatile Connection connection;

    @Inject
    public ConnectionHolder(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws IOException {
        if (this.connection == null) {
            ConnectionHolder connectionHolder = this;
            synchronized (connectionHolder) {
                if (this.connection == null) {
                    this.log.info("creating a connection to AMQP server");
                    this.connection = this.connectionFactory.newConnection();
                }
            }
        }
        return this.connection;
    }

    public void closeConnection() {
        if (this.connection == null) {
            return;
        }
        Connection oldConnection = this.connection;
        this.connection = null;
        this.log.info("closing connection");
        try {
            oldConnection.close();
        }
        catch (ShutdownSignalException | IOException e) {
            this.log.error("could not close connection, ignore", e);
        }
    }

    public Channel createNewChannel() throws IOException {
        if (this.connection == null) {
            this.getConnection();
        }
        try {
            this.log.info("..createChannel");
            return this.connection.createChannel();
        }
        catch (ShutdownSignalException | IOException e) {
            this.log.error("could not create channel from connection -- closing connection", e);
            this.closeConnection();
            throw e;
        }
    }
}

