/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2ClientConfig
implements OAuth2TokenConfig {
    private String baseUrl;
    private String tokenUrl;
    @JsonProperty
    private String introspectionUrl;
    @JsonProperty
    private String clientId;
    @JsonProperty
    private String clientSecret;
    @JsonProperty
    private String publicKeyPath;

    public String getIntrospectionUrl() {
        return this.introspectionUrl;
    }

    public void setIntrospectionUrl(String introspectionUrl) {
        this.introspectionUrl = introspectionUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getPublicKeyPath() {
        return this.publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws ConfigException {
        if (this.publicKeyPath == null) {
            throw new ConfigException("SigningKeyPath must be set", null);
        }
        try {
            return KeyReaderRSA.getPublicKey(this.publicKeyPath);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigException(null, e);
        }
    }
}

