package net.leanix.dropkit;

import net.leanix.dropkit.oauth.OAuth2ResourceServerConfig;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This configuration is to be used by microservices, which want to
 * authenticate incoming requests, e.g. webhooks
 */
public class ConfigurationResourceServer extends ConfigurationWithCORS {

    private OAuth2ResourceServerConfig oauth = new OAuth2ResourceServerConfig();

    /**
     * Returns the necessary configuration to run oauth resource providers.
     * Values can be empty.
     */
    @JsonProperty("oauth")
    public OAuth2ResourceServerConfig getOAuth2TokenConfig() {
        return oauth;
    }

    @JsonProperty("oauth")
    public void setOAuth2TokenConfig(OAuth2ResourceServerConfig config) {
        this.oauth = config;
    }
}
