/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;
import net.leanix.dropkit.oauth.token.OAuth2TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OAuth2Authenticator<U extends User>
implements Authenticator<String, U> {
    private final Logger logger = LoggerFactory.getLogger(OAuth2Authenticator.class);
    private final OAuth2TokenParser parser;
    private final Class<U> userClass;

    @Inject
    public OAuth2Authenticator(OAuth2TokenConfig config, Class<U> userClass) {
        try {
            this.parser = new OAuth2TokenParser(config);
            this.userClass = userClass;
        }
        catch (Exception e) {
            throw new RuntimeException("unhandleable exception", e);
        }
    }

    public Optional<U> authenticate(String accessToken) throws AuthenticationException {
        if (accessToken == null) {
            this.logger.warn("No token provided");
            return Optional.empty();
        }
        try {
            OAuth2Token<U> token = this.parser.parse(accessToken, this.userClass);
            return Optional.ofNullable(token.getPrincipal());
        }
        catch (ExpiredJwtException ex) {
            this.logger.warn("Token expired");
            return Optional.empty();
        }
        catch (JwtException ex) {
            this.logger.warn("Unable to verify token: ", (Throwable)ex);
            return Optional.empty();
        }
        catch (Throwable ex) {
            throw new AuthenticationException("Unable to authenticate token", ex);
        }
    }
}

