/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.dropwizard.Configuration;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.text.DateFormat;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import net.leanix.dropkit.BusinessLogicExceptionMapper;
import net.leanix.dropkit.ConfigurationWithCORS;
import net.leanix.dropkit.InvalidEntityMapper;
import org.apache.commons.text.StrSubstitutor;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public class AppHelper {
    public void initializeISO8601(Bootstrap<? extends Configuration> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)new JodaModule());
        bootstrap.getObjectMapper().setDateFormat((DateFormat)new StdDateFormat());
    }

    public void initialize(Bootstrap<? extends Configuration> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor(false)));
        this.initializeISO8601(bootstrap);
    }

    public void run(ConfigurationWithCORS config, Environment environment) {
        this.addCORSFilter(environment, config);
        this.registerExceptionMappers(environment);
    }

    public void registerExceptionMappers(Environment environment) {
        environment.jersey().register((Object)new InvalidEntityMapper());
        environment.jersey().register((Object)new BusinessLogicExceptionMapper());
    }

    public void addCORSFilter(Environment environment, ConfigurationWithCORS config) {
        if (config == null || config.getCrossOriginConfig() == null || config.getCrossOriginConfig().getWhitelist() == null) {
            return;
        }
        if (config.getCrossOriginConfig().getWhitelist().equalsIgnoreCase("null")) {
            return;
        }
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        filter.setInitParameter("allowedHeaders", "accept,accept-encoding,accept-language,access-control-request-headers,access-control-request-method,api-key,authorization,cache-control,content-type,content-length,connection,host,pragma,referer,x-requested-with,origin,x-api-sync-mode,x-api-key,x-credentials");
        filter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter("preflightMaxAge", "5184000");
        filter.setInitParameter("allowCredentials", "true");
        filter.setInitParameter("allowedOrigins", config.getCrossOriginConfig().getWhitelist());
    }
}

