/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotNull;
import net.leanix.dropkit.util.k8s.ContainerRole;

public class ContainerK8sConfiguration {
    @NotNull
    @JsonProperty(value="enabled")
    private boolean runsInKubernetes = false;
    @JsonProperty(value="role")
    private String appRole = ContainerRole.SERVER.toString();

    public boolean isRunningInKubernetes() {
        return this.runsInKubernetes;
    }

    public boolean isServer() {
        return ContainerRole.fromString(this.appRole) == ContainerRole.SERVER;
    }

    public boolean isJobsPod() {
        return ContainerRole.fromString(this.appRole) == ContainerRole.JOBS;
    }

    public boolean isMigration() {
        return ContainerRole.fromString(this.appRole) == ContainerRole.MIGRATION;
    }

    public boolean isKubernetesJobExecutionEnabled() {
        return this.isRunningInKubernetes() && this.isJobsPod();
    }
}

