/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.jwks;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import net.leanix.dropkit.oauth.jwks.SigningKeyResolverJWKS;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2TokenParserJWKS<U extends User> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<U> userClass;
    private final JwtParser jwtParser;

    public OAuth2TokenParserJWKS(OAuth2TokenConfig oauth2TokenConfig, Class<U> userClass) throws ConfigException {
        this(oauth2TokenConfig, userClass, new SigningKeyResolverJWKS(oauth2TokenConfig));
    }

    public OAuth2TokenParserJWKS(OAuth2TokenConfig oauth2TokenConfig, Class<U> userClass, SigningKeyResolver signingKeyResolver) throws ConfigException {
        this.userClass = userClass;
        this.jwtParser = Jwts.parser().setSigningKeyResolver(signingKeyResolver);
    }

    public OAuth2Token<U> parse(String accessToken) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(accessToken).getBody();
        User user = (User)this.mapper.convertValue(claims.get((Object)"principal"), this.userClass);
        try {
            user.setSvcUrl(new URL(claims.getIssuer()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OAuth2Token<User> token = new OAuth2Token<User>();
        token.setId(UUID.fromString(claims.getId()));
        token.setPrincipal(user);
        user.setAccessToken(accessToken);
        token.setExpiration(claims.getExpiration());
        if (claims.get((Object)"refresh_token") != null) {
            token.setRefreshToken((String)claims.get("refresh_token", String.class));
        }
        if (claims.get((Object)"refresh_expiration") != null) {
            token.setRefreshExpiration((Date)claims.get("refresh_exp", Date.class));
        }
        return token;
    }
}

