/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2ResourceServerConfig
implements OAuth2TokenConfig {
    @JsonProperty
    private String publicKeyPath;
    @JsonProperty
    private URL jwksUri;

    public String getPublicKeyPath() {
        return this.publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws ConfigException {
        if (this.publicKeyPath == null) {
            throw new ConfigException("SigningKeyPath must be set", null);
        }
        try {
            return KeyReaderRSA.getPublicKey(this.publicKeyPath);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigException(null, e);
        }
    }

    @Override
    public URL getJwksUri() {
        return this.jwksUri;
    }
}

