package net.leanix.dropkit.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;

import java.io.IOException;

/**
 * Keeps json value as json, does not try to deserialize it
 *
 * modified to include validation while the json intestines are accessible
 *
 * @author roytruelove
 * { @link http://stackoverflow.com/questions/8137060/jackson-deserialize-variable-as-json-string/24085052#24085052 }
 */
public class RawJsonDeserializer extends JsonDeserializer<String> {

    @Override
    public String deserialize(JsonParser jp, DeserializationContext ctxt)
            throws IOException {

        JsonNode tree = jp.getCodec().readTree(jp);

        validate(tree);

        if (tree == null) {
            return null;
        }

        return tree.toString();
    }

    /**
     * Validates the parsed json structure.
     * Subclasses can override this to enforce some special requirements.
     * This implementation succeeds on every input.
     *
     * @param node the root node of the json structure to validate
     * @throws JsonProcessingException if validation fails
     */
    protected void validate(JsonNode node) throws JsonProcessingException {}
}
