package net.leanix.dropkit;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.leanix.dropkit.responses.BasicResponse;

/**
 *
 * { @link http://stackoverflow.com/questions/24573028/dropwizard-custom-exception-for-invalidentityexception }
 */
@Provider
public class BusinessLogicExceptionMapper implements ExceptionMapper<BusinessLogicException> {

    /**
     * Builds a response. Remark: Should not automatically log its results, otherwise any exception ends up in log file,
     * although business logic exceptions should not end up here
     *
     * @param ex Exception
     * @return response
     */
    @Override
    public Response toResponse(BusinessLogicException ex) {
        return Response.status(ex.getStatus())
                .entity(new BasicResponse(ex))
                .type("text/json")
                .build();
    }
}
