/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class Payload {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final Map<String, Object> fields = new HashMap<String, Object>();

    public static Payload fromObject(Object o) {
        String encoded;
        if (o == null) {
            return new Payload();
        }
        try {
            encoded = MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(Payload.class.getName()).log(Level.WARNING, "Transformation from object failed.", ex);
            return new Payload();
        }
        return Payload.fromString(encoded);
    }

    public static Payload fromString(String encoded) {
        try {
            return (Payload)MAPPER.readValue(encoded, Payload.class);
        }
        catch (IOException ex) {
            Logger.getLogger(Payload.class.getName()).log(Level.WARNING, "Deserialization from string failed", ex);
            return new Payload();
        }
    }

    public String toString() {
        try {
            return MAPPER.writeValueAsString(this.toMap());
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(Payload.class.getName()).log(Level.WARNING, "Serialization to string failed", ex);
            return null;
        }
    }

    public Map<String, Object> toMap() {
        return this.fields;
    }

    @JsonAnySetter
    public void setKey(String key, Object value) {
        this.fields.put(key, value);
    }

    @JsonAnyGetter
    public Object getKey(String key) {
        if (!this.fields.containsKey(key)) {
            return null;
        }
        return this.fields.get(key);
    }
}

