/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.google.common.hash.HashCode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.leanix.dropkit.util.HashUtil;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashUtilTest {
    private static final Logger LOG = LoggerFactory.getLogger(HashUtilTest.class);

    @Test
    public void hash_nullInput_nullOutput() {
        String input = null;
        String output = HashUtil.hash(input);
        Assertions.assertThat((String)output).isNull();
    }

    @Test
    public void hash_emptyInput_emptyOutput() {
        String input = "";
        String output = HashUtil.hash((String)input);
        Assertions.assertThat((String)output).isEmpty();
    }

    @Test
    public void hash_whitespaceInput_emptyOutput() {
        String input = " \t   \n    ";
        String output = HashUtil.hash((String)input);
        Assertions.assertThat((String)output).isEmpty();
    }

    @Test
    public void hash_differentInput_differentOutput() {
        String inputA = "foobar";
        String inputB = "barfoo";
        String outputA = HashUtil.hash((String)inputA);
        String outputB = HashUtil.hash((String)inputB);
        Assertions.assertThat((String)outputA).isNotEqualTo((Object)outputB);
    }

    @Test
    public void hash_multipleRuns_sameOutput() {
        String input = "foobar";
        String outputA = HashUtil.hash((String)input);
        String outputB = HashUtil.hash((String)input);
        Assertions.assertThat((String)outputA).isEqualTo((Object)outputB);
    }

    @Test
    public void hash_checkIfSaltIsApplied() throws NoSuchAlgorithmException {
        String input = "foobar";
        String output = HashUtil.hash((String)input);
        byte[] hash = MessageDigest.getInstance("SHA-512").digest(input.getBytes(StandardCharsets.UTF_8));
        String compare = HashCode.fromBytes((byte[])hash).toString();
        Assertions.assertThat((String)output).isNotEqualTo((Object)compare);
    }

    @Test
    @Ignore
    public void hash_benchmarkRuntime() {
        int testSize = 100000;
        List randomUUIDs = IntStream.rangeClosed(1, 100000).mapToObj(i -> UUID.randomUUID().toString()).collect(Collectors.toList());
        long start = System.nanoTime();
        List hashedUUIDs = randomUUIDs.stream().map(HashUtil::hash).collect(Collectors.toList());
        long end = System.nanoTime();
        IntStream.range(0, randomUUIDs.size()).forEach(i -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)((String)randomUUIDs.get(i))).isNotEqualTo(hashedUUIDs.get(i));
        });
        double totalTimeMilli = (double)(end - start) / 1000000.0;
        double averageTimeMilli = (double)(end - start) / (double)randomUUIDs.size() / 1000000.0;
        LOG.info("Hashing of {} UUIDs took {} ms in average (total: {} ms)", new Object[]{randomUUIDs.size(), averageTimeMilli, totalTimeMilli});
    }
}

