package net.leanix.dropkit.util;

import com.google.common.hash.HashCode;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtil {

    static final String HASH_ALGORITHM = "SHA-512";
    private static final byte[] SALT = "44j6VBhUTV6eWYT5BPYkwBuRFD6aXqr8".getBytes();

    static {
        try {
            MessageDigest.getInstance(HASH_ALGORITHM);
        } catch (NoSuchAlgorithmException e) {
            // Assure that service cannot start when this happens
            throw new ExceptionInInitializerError(e);
        }
    }

    private HashUtil() {
    }

    public static String hash(String input) {
        if (input == null) {
            return input;
        }
        input = input.trim();
        if (input.isEmpty()) {
            return input;
        }
        try {
            // We need to create this every time because message digest is not thread safe
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            messageDigest.update(SALT);
            byte[] hash = messageDigest.digest(input.getBytes(StandardCharsets.UTF_8));
            return HashCode.fromBytes(hash).toString();
        } catch (NoSuchAlgorithmException e) {
            // This will never happen in the JVMs because the service already fails on initialization (see above)
        }
        return input;
    }
}
