package net.leanix.dropkit.oauth.jwks;

import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.ws.rs.ext.Provider;
import net.leanix.dropkit.oauth.models.User;

/**
 * A feature implementation used to support oauth2 validation.
 * 
 * <pre>
 *   Requires a provider in application's module class like:
 *   
 *   @Provides
 *   public OAuth2AuthenticatorJWKS<User> getAuthenticator(AppConfiguration configuration) {
 *      return new OAuth2AuthenticatorJWKS<>(configuration.getOAuth2TokenConfig(), User.class);
 *   }
 * </pre>
 */
@Provider
public class OAuth2DynamicFeatureJKS extends AuthDynamicFeature {

    @Inject
    public OAuth2DynamicFeatureJKS(OAuth2AuthenticatorJWKS<User> authenticator, Environment environment) {
        super(new OAuthCredentialAuthFilter.Builder<User>()
            .setAuthenticator(authenticator)
            .setPrefix("Bearer")
            .buildAuthFilter());

        environment.jersey().register(new AuthValueFactoryProvider.Binder<>(User.class));
    }
}
