/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);

    public static URI getFirstReachableAddress(URI ... testUris) {
        for (URI uri : testUris) {
            try {
                InetAddress address = InetAddress.getByName(uri.getHost());
                if (!address.isReachable(250)) continue;
                LOG.info("Found http connection on '{}'.", (Object)uri.toString());
                return uri;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int findFreeSocket(int startPort, int endPortRange) {
        if (startPort <= 0) {
            throw new IllegalArgumentException("The parameter 'startPort' must be greater than zero.");
        }
        if (endPortRange < startPort) {
            throw new IllegalArgumentException("The argument 'endPortRange' must be greater or equal to parameter 'startPort'.");
        }
        for (int testPort = startPort; testPort <= endPortRange; ++testPort) {
            if (!NetworkUtils.isSocketAvailable(testPort)) continue;
            return testPort;
        }
        throw new RuntimeException("No port in range " + startPort + " - " + endPortRange + " is available.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isSocketAvailable(int port) {
        LOG.debug("trying to open port {}", (Object)port);
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.info("port {} is unavailable", (Object)port);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to close socket " + port);
                }
            }
        }
        return false;
    }

    public static int findFirstPort(String host, int startPort, int endPort, boolean testOfListening) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            for (int testPort = startPort; testPort <= endPort; ++testPort) {
                boolean isListening = NetworkUtils.isSocketListening(inetAddress, testPort);
                if (!testOfListening && !isListening) {
                    return testPort;
                }
                if (!testOfListening || !isListening) continue;
                return testPort;
            }
            throw new RuntimeException("No port in range " + startPort + " - " + endPort + " on host " + host + " found.");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSocketListening(InetAddress inetAddress, int testPort) {
        LOG.debug("testing port '{}:{}'", (Object)inetAddress.getHostName(), (Object)testPort);
        try {
            new Socket(inetAddress, testPort).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

