/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.jwks;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.SigningKeyNotFoundException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import java.net.MalformedURLException;
import java.security.Key;
import java.security.PublicKey;
import net.leanix.dropkit.oauth.jwks.SigningKeyResolverJWKS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SigningKeyResolverJWKSTest {
    @Mock
    private JwsHeader<?> jwsHeader;
    @Mock
    private JwkProvider jwkProvider;

    @Before
    public void beforeEach() throws MalformedURLException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.jwsHeader.getKeyId()).thenReturn((Object)"myKeyId");
    }

    @Test
    public void test_resolveSigningKey_jwksEndpointNotAvailable_LeagcyKeyIsUsed() throws JwkException {
        Mockito.when((Object)this.jwkProvider.get(Mockito.anyString())).thenThrow(new Throwable[]{new JwkException("something goes wrong")});
        Key fallbackKey = (Key)Mockito.mock(Key.class);
        SigningKeyResolverJWKS resolver = new SigningKeyResolverJWKS(this.jwkProvider, fallbackKey);
        Key key = resolver.resolveSigningKey(this.jwsHeader, (Claims)Mockito.mock(Claims.class));
        Assert.assertSame((Object)key, (Object)fallbackKey);
    }

    @Test
    public void test_resolveSigningKey_jwksEndpointNotAvailable_noConfiguredLegacyPublicKey() throws JwkException {
        Mockito.when((Object)this.jwkProvider.get(Mockito.anyString())).thenThrow(new Throwable[]{new SigningKeyNotFoundException("- not found -", null)});
        SigningKeyResolverJWKS resolver = new SigningKeyResolverJWKS(this.jwkProvider, null);
        Key key = resolver.resolveSigningKey(this.jwsHeader, (Claims)Mockito.mock(Claims.class));
        Assert.assertNull((Object)key);
    }

    @Test
    public void test_resolveSigningKey_success_provideKeyFromJwks() throws JwkException {
        PublicKey pubKeyFromEndpoint = (PublicKey)Mockito.mock(PublicKey.class);
        Jwk foundJwk = (Jwk)Mockito.mock(Jwk.class);
        Mockito.when((Object)foundJwk.getPublicKey()).thenReturn((Object)pubKeyFromEndpoint);
        Mockito.when((Object)this.jwkProvider.get((String)Mockito.eq((Object)"myKeyId"))).thenReturn((Object)foundJwk);
        SigningKeyResolverJWKS resolver = new SigningKeyResolverJWKS(this.jwkProvider, null);
        Key key = resolver.resolveSigningKey(this.jwsHeader, (Claims)Mockito.mock(Claims.class));
        Assert.assertSame((Object)key, (Object)pubKeyFromEndpoint);
    }
}

