package net.leanix.dropkit.responses;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * A generic entity container for api responses.
 * @deprecated
 */
@JsonInclude(Include.NON_NULL)
public abstract class Response<T> extends BasicResponse {

    protected T data;

    public Response() {
        super();
    }

    /**
     * Constructor for a result containing a single entity.
     */
    public Response(T entity) {
        status = ResponseStatus.OK;
        data = entity;
        type = entity.getClass().getSimpleName();
    }

    @JsonInclude
    public abstract T getData();

    public void setData(T data) {
        this.data = data;
    }
}
