/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestUtil.class);
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Manifest> findManifestForJar(String bootJarName) {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(META_INF_MANIFEST_MF);
            ArrayList<URL> resouresList = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                URL nextElement = resources.nextElement();
                resouresList.add(nextElement);
            }
            if (resouresList.isEmpty()) {
                return Optional.empty();
            }
            Collections.reverse(resouresList);
            URL relevantUrl = resouresList.stream().peek(url -> LOG.debug("found: {}", url)).filter(url -> url.toString().contains(bootJarName)).findFirst().orElse((URL)resouresList.get(0));
            try (InputStream is = relevantUrl.openStream();){
                LOG.info("parsing manifest from url '{}'", (Object)relevantUrl);
                Optional<Manifest> optional = Optional.of(new Manifest(is));
                return optional;
            }
        }
        catch (IOException e) {
            LOG.warn("failed to load resource '{}' for boot jar '{}'", new Object[]{META_INF_MANIFEST_MF, bootJarName, e});
            return Optional.empty();
        }
    }

    public static ManifestGauge createManifestGauge(Manifest manifest) {
        return new ManifestGauge(manifest);
    }

    public static class ManifestGauge
    implements MetricSet {
        private final Manifest manifest;

        ManifestGauge(Manifest manifest) {
            this.manifest = manifest;
        }

        public Map<String, Metric> getMetrics() {
            HashMap<String, Object> gauges = new HashMap<String, Object>();
            gauges.put("version", new Gauge<String>(){

                public String getValue() {
                    return this.readFromManifest("Implementation-Version");
                }
            });
            gauges.put("title", new Gauge<String>(){

                public String getValue() {
                    return this.readFromManifest("Implementation-Title");
                }
            });
            return Collections.unmodifiableMap(gauges);
        }

        protected String readFromManifest(String name) {
            Attributes attributes = this.manifest.getMainAttributes();
            String value = "---";
            if (attributes != null) {
                value = attributes.getValue(name);
            }
            return value;
        }
    }
}

