package net.leanix.dropkit.util.k8s;

import net.leanix.dropkit.util.DeploymentUtil;

public class ContainerJobsHandlingHelper {

    // helper method to determine if application is running on legacy mode or as a kubernetes pod with jobs role
    public static boolean mustScheduleJobs(ContainerK8sConfiguration kubernetesConfiguration) {
        if (kubernetesConfiguration.isRunningInKubernetes()) {
            return kubernetesConfiguration.isJobsPod();
        }
        // legacy mode
        return true;
    }

    public static boolean mustExecuteJob(DeploymentUtil deploymentUtil, ContainerK8sConfiguration kubernetesConfiguration) {
        if (kubernetesConfiguration.isRunningInKubernetes()) {
            return kubernetesConfiguration.isJobsPod();
        } else {
            return deploymentUtil.isInstanceCurrentlyActive();
        }
    }
}
