package net.leanix.dropkit.oauth.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;

import java.util.UUID;

/**
 * Interface to identify an authenticated user.
 *
 *
 */
public interface Principal extends java.security.Principal {

    /**
     * Returns the UUID string representation for regular users or a resource
     * server key or a client key.
     */
    UUID getId();

    /**
     * Returns the username.
     */
    String getUsername();

    /**
     * Returns the account (=company).
     */
    Account getAccount();

    /**
     * Returns the role of the user in his company.
     */
    @ApiModelProperty(dataType = "string")
    UserRole getRole();

    /**
     * Return the status of the user.
     */
    @ApiModelProperty(dataType = "string")
    UserStatus getStatus();

    /**
     * Convenience method to check if user is active and has the given role.
     */
    @ApiModelProperty(hidden = true)
    boolean isActive(UserRole role);

    /**
     * Returns the permission for the active workspace
     */
    Permission getPermission();

    /**
     * Convenience method to check is user has permission with given role
     */
    @ApiModelProperty(hidden = true)
    boolean hasPermission(UUID workspaceId, PermissionRole role);

    @ApiModelProperty(hidden = true)
    boolean hasPermission(UUID workspaceId);

    @ApiModelProperty(hidden = true)
    String getAccessToken();

    @Override
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    String getName();
}
