/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenParserInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2TokenParserBase
implements OAuth2TokenParserInterface {
    private static final Logger log = LoggerFactory.getLogger(OAuth2TokenParserBase.class);
    private final JwtParser jwtParser;

    public OAuth2TokenParserBase(JwtParser jwtParser) {
        this.jwtParser = jwtParser;
    }

    @Override
    public <U extends User> OAuth2Token<U> parse(String accessToken, Class<U> userClass) {
        Claims claims = (Claims)this.jwtParser.parseClaimsJws(accessToken).getBody();
        ObjectMapper mapper = new ObjectMapper();
        User user = (User)mapper.convertValue(claims.get((Object)"principal"), userClass);
        try {
            user.setSvcUrl(new URL(claims.getIssuer()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OAuth2Token<User> token = new OAuth2Token<User>();
        if (claims.getId() != null) {
            token.setId(UUID.fromString(claims.getId()));
        } else {
            log.error("no jti claim in JWT! Why? This is safe, and should disappear once all old JWT have expired");
        }
        token.setPrincipal(user);
        user.setAccessToken(accessToken);
        token.setExpiration(claims.getExpiration());
        if (claims.get((Object)"refresh_token") != null) {
            token.setRefreshToken((String)claims.get("refresh_token", String.class));
        }
        if (claims.get((Object)"refresh_exp") != null) {
            token.setRefreshExpiration((Date)claims.get("refresh_exp", Date.class));
        }
        return token;
    }
}

