package net.leanix.dropkit.oauth.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;

/**
 * User representation on the side of resource providers.
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class User implements Serializable, Principal {

    private static final long serialVersionUID = 1L;
    
    private UUID id;
    private String username;
    private UserRole role;
    private UserStatus status;
    private Account account;
    private Permission permission;
    private URL svcUrl;

    @JsonIgnore
    private String accessToken;

    public User() {
        this.id = null;
        this.username = null;
    }

    @Override
    @ApiModelProperty(dataType = "string")
    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @Override
    public Permission getPermission() {
        return permission;
    }

    public boolean hasPermission(UUID workspaceId, PermissionRole role) {
        if (this.permission != null) {
            return this.permission.isActive() && this.permission.getWorkspaceId().equals(workspaceId) && this.permission.hasRole(role);
        }

        return false;
    }

    @Override
    public boolean hasPermission(UUID workspaceId) {
        if (this.permission != null) {
            return this.permission.isActive() && this.permission.getWorkspaceId().equals(workspaceId);
        }

        return false;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    @ApiModelProperty(dataType = "string")
    public UserRole getRole() {
        return role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    @Override
    @ApiModelProperty(dataType = "string")
    public UserStatus getStatus() {
        return status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    @Override
    @JsonIgnore
    public boolean isActive(UserRole role) {
        return getRole() != null && getRole().equals(role)
                && UserStatus.ACTIVE.equals(status);
    }

    @Override
    @JsonIgnore
    public String getAccessToken() {
        return accessToken;
    }

    @JsonIgnore
    public void setAccessToken(String token) {
        this.accessToken = token;
    }

    @Override
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    public String getName() {
        return getUsername();
    }

    @JsonIgnore
    public void setSvcUrl(URL svcUrl) {
        if (svcUrl == null) {
            throw new IllegalArgumentException("SVC url may not be null");
        }
        this.svcUrl = svcUrl;
    }

    @JsonIgnore
    public URL getSvcUrl() {
        return svcUrl;
    }
}
