package net.leanix.dropkit;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import net.leanix.dropkit.oauth.OAuth2AuthServerConfig;

/**
 * This configuration is to be used by oAuth Server, i.e. mtm
 *
 * @author andre
 */
public class ConfigurationAuthServer extends ConfigurationWithCORS {
    protected OAuth2AuthServerConfig oauth = new OAuth2AuthServerConfig();

    /**
     * Returns the necessary configuration to run oauth resource providers.
     *
     * Values can be empty.
     */
    @JsonProperty("oauth")
    public OAuth2AuthServerConfig getOAuth2TokenConfig() {
        return oauth;
    }

    @JsonProperty("oauth")
    public void setOAuth2TokenConfig(OAuth2AuthServerConfig oAuth) {
        this.oauth = oAuth;
    }
}
