/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.quartz;

import com.google.inject.Singleton;
import io.dropwizard.lifecycle.Managed;
import javax.inject.Inject;
import net.leanix.dropkit.quartz.LxGuiceJobFactory;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SimpleManagedJobScheduler
implements Managed {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleManagedJobScheduler.class);
    private final Scheduler scheduler = new StdSchedulerFactory().getScheduler();
    private final LxGuiceJobFactory jobFactory;

    @Inject
    public SimpleManagedJobScheduler(Scheduler scheduler, LxGuiceJobFactory jobFactory) throws SchedulerException {
        this.jobFactory = jobFactory;
    }

    public static SimpleManagedJobScheduler getInstance() throws SchedulerException {
        return new SimpleManagedJobScheduler(new StdSchedulerFactory().getScheduler(), null);
    }

    public void addJob(Class<? extends Job> jobClass, long intervalInMilliseconds) throws SchedulerException {
        if (intervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Parameter intervalInMilliseconds must be greater than 0.");
        }
        JobDetail jobDetail = JobBuilder.newJob(jobClass).build();
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(intervalInMilliseconds).repeatForever()).build();
        LOG.info("Adding new job {} with trigger {} to quartz scheduler.", (Object)jobDetail, (Object)trigger);
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void start() throws Exception {
        LOG.info("Starting quartz scheduler");
        if (this.jobFactory != null) {
            this.scheduler.setJobFactory((JobFactory)this.jobFactory);
        }
        this.scheduler.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping quartz scheduler");
        this.scheduler.shutdown(true);
    }
}

