/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.leanix.dropkit.util.async.RetryExecutor;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class RetryExecutorTest {
    RetryExecutor retryExecutor;

    @Before
    public void setup() {
        this.retryExecutor = new RetryExecutor(1, 200, TimeUnit.MILLISECONDS, "RetryExecutor-%d");
    }

    @Test
    public void test_run_twoRunnables() throws InterruptedException, ExecutionException {
        CountDownLatch i = new CountDownLatch(3);
        AtomicInteger reachedPossible = new AtomicInteger(0);
        AtomicInteger reachedFail = new AtomicInteger(0);
        RetryExecutor.RetryTask taskPossible = count -> {
            System.out.println(Thread.currentThread() + " #" + count + " possible " + i.getCount());
            reachedPossible.incrementAndGet();
            i.countDown();
            if (i.getCount() > 0L) {
                System.out.println(" unable to finish " + i.getCount());
                throw new RuntimeException("exception No " + i.getCount());
            }
        };
        RetryExecutor.RetryTask taskFail = count -> {
            System.out.println(Thread.currentThread() + " #" + count + " fail " + i.getCount());
            reachedFail.incrementAndGet();
            throw new RuntimeException("exception No " + i.getCount());
        };
        this.retryExecutor.run(taskPossible);
        this.retryExecutor.run(taskFail);
        i.await(1L, TimeUnit.MINUTES);
        System.out.println(String.format("possible: %d, fail: %d", reachedPossible.get(), reachedFail.get()));
        Assertions.assertThat((int)reachedPossible.get()).isEqualTo(3);
        Assertions.assertThat((int)reachedFail.get()).isGreaterThanOrEqualTo(1);
        this.retryExecutor.stop();
    }

    @Test
    public void test_run_twoPossibleOneFailingRunnables() throws InterruptedException, ExecutionException {
        CountDownLatch countDown = new CountDownLatch(4);
        AtomicInteger reachedPossible = new AtomicInteger(0);
        AtomicInteger reachedFail = new AtomicInteger(0);
        RetryExecutor.RetryTask taskPossible = count -> {
            System.out.println(Thread.currentThread() + " possible " + reachedPossible.get());
            reachedPossible.incrementAndGet();
            countDown.countDown();
            if (countDown.getCount() > 0L) {
                System.out.println(" unable to finish " + countDown.getCount());
                throw new RuntimeException("exception No " + countDown.getCount());
            }
        };
        RetryExecutor.RetryTask taskFail = count -> {
            System.out.println(Thread.currentThread() + " fail " + reachedFail.get());
            reachedFail.incrementAndGet();
            throw new RuntimeException("exception No " + countDown.getCount());
        };
        this.retryExecutor.run(taskPossible);
        this.retryExecutor.run(taskFail);
        this.retryExecutor.run(taskPossible);
        countDown.await(1L, TimeUnit.MINUTES);
        System.out.println(String.format("possible: %d, fail: %d", reachedPossible.get(), reachedFail.get()));
        Assertions.assertThat((int)reachedPossible.get()).isEqualTo(4);
        Assertions.assertThat((int)reachedFail.get()).isGreaterThanOrEqualTo(1);
        this.retryExecutor.stop();
    }

    @Test
    public void test_run_stopPendingRunnables() throws InterruptedException, ExecutionException {
        CountDownLatch countDown = new CountDownLatch(1);
        AtomicInteger reachedPossible = new AtomicInteger(0);
        AtomicInteger finishedPossible = new AtomicInteger(0);
        RetryExecutor.RetryTask taskPossible = count -> {
            System.out.println(Thread.currentThread() + " long processing runnable " + reachedPossible.get());
            reachedPossible.incrementAndGet();
            countDown.countDown();
            try {
                Thread.sleep(500L);
                finishedPossible.incrementAndGet();
            }
            catch (InterruptedException e) {
                System.out.println("received InterruptedException!");
            }
        };
        this.retryExecutor.run(taskPossible);
        countDown.await(1L, TimeUnit.MINUTES);
        this.retryExecutor.stop();
        Assertions.assertThat((int)reachedPossible.get()).isEqualTo(1);
        Assertions.assertThat((int)finishedPossible.get()).isEqualTo(0);
    }
}

