/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.testenvironments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.leanix.dropkit.util.ProcessWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GitUtil.class);

    public String getCurrentBranchName() throws InterruptedException {
        ProcessWrapper start;
        List<String> cmds = Arrays.asList("git", "status");
        ProcessBuilder pb = new ProcessBuilder(cmds);
        ProcessWrapper processWrapper = new ProcessWrapper(pb);
        final CountDownLatch versionLatch = new CountDownLatch(1);
        final ArrayList lines = new ArrayList();
        try {
            start = processWrapper.start(new ProcessWrapper.StdXXXLineListener(){

                public boolean fireNewLine(String line) {
                    LOG.debug(line);
                    lines.add(line);
                    versionLatch.countDown();
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Can not run git command");
            return null;
        }
        versionLatch.await(5L, TimeUnit.SECONDS);
        Thread.sleep(100L);
        if (start != null && start.getExitValue() != 0) {
            throw new RuntimeException("Process ended with exit value " + start.getExitValue());
        }
        Pattern pattern = Pattern.compile("On branch (.*)$");
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.toMatchResult().group(1);
        }
        return null;
    }

    public boolean isMasterBranchCheckedOut() throws InterruptedException {
        return "master".equals(this.getCurrentBranchName());
    }
}

