package net.leanix.dropkit.etcd;

import java.net.URI;

/**
 * A factory which creates the {@linkplain MinimalEtcdClient} instance to give the user the chance to use another client than the
 * default {@linkplain MinimalEtcdClientImpl} from leanix-dropkit.
 * 
 * @author ralfwehner
 *
 */
public class MinimalEtcdClientFactory {

    public MinimalEtcdClient create(URI etcdUri) {
        return new MinimalEtcdClientImpl(etcdUri);
    }
}
