/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public class AMQPConfiguration {
    @JsonProperty
    private String exchange = "";
    @JsonProperty
    private String queueBase = "net.leanix.queue";
    @JsonProperty
    private String queueSuffix = "white";
    @NotEmpty
    @JsonProperty
    private String host;
    @Min(value=1L)
    @Max(value=65535L)
    @JsonProperty
    private int port = 5672;
    @NotEmpty
    @JsonProperty
    private String username = "guest";
    @NotEmpty
    @JsonProperty
    private String password = "guest";

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getQueueBase() {
        return this.queueBase;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setQueueBase(String queue) {
        this.queueBase = queue;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueueSuffix() {
        return this.queueSuffix;
    }

    public void setQueueSuffix(String queueSuffix) {
        this.queueSuffix = queueSuffix;
    }

    public String getQueue() {
        return this.queueBase + "." + this.queueSuffix;
    }
}

