/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.testenvironments;

import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.testing.junit.ResourceTestRule;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestFilter;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.models.UserRole;
import net.leanix.dropkit.oauth.models.UserStatus;
import org.glassfish.jersey.test.grizzly.GrizzlyWebTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DropkitResourceTestRule
implements TestRule {
    protected final User user = this.createUser();
    protected final Authenticator<String, User> authenticator = credentials -> Optional.of(this.user);
    private final ResourceTestRule rule;

    protected User createUser() {
        User user = new User();
        user.setId(UUID.randomUUID());
        user.setRole(UserRole.SYSTEM);
        user.setStatus(UserStatus.ACTIVE);
        return user;
    }

    public DropkitResourceTestRule(Object ... resources) {
        ResourceTestRule.Builder resourceTestRuleBuilder = ResourceTestRule.builder().setTestContainerFactory((TestContainerFactory)new GrizzlyWebTestContainerFactory()).addProvider((Object)new AuthDynamicFeature((ContainerRequestFilter)new OAuthCredentialAuthFilter.Builder().setPrefix("Bearer").setAuthenticator(this.authenticator).buildAuthFilter())).addProvider((Object)new AuthValueFactoryProvider.Binder(User.class));
        for (Object resource : resources) {
            resourceTestRuleBuilder.addResource(resource);
        }
        this.rule = resourceTestRuleBuilder.build();
    }

    public Statement apply(Statement base, Description description) {
        return this.rule.apply(base, description);
    }

    public ResourceTestRule getRule() {
        return this.rule;
    }

    public User getUser() {
        return this.user;
    }
}

