package net.leanix.dropkit.oauth;

import net.leanix.dropkit.oauth.models.User;

import com.google.inject.Inject;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.setup.Environment;

import javax.ws.rs.ext.Provider;

@Provider
public class OAuth2DynamicFeature extends AuthDynamicFeature {
    @Inject
    // OAuth2Authenticator<User> could be replaced by an additional dummy subclass
    // (UserAuthenticator extends OAuth2Authenticator<User>)
    // to avoid the extra need to bind and authenticator
    public OAuth2DynamicFeature(OAuth2Authenticator<User> authenticator, Environment environment) {
        super(new OAuthCredentialAuthFilter.Builder<User>()
                .setAuthenticator(authenticator)
                .setPrefix("Bearer")
                .buildAuthFilter());

        environment.jersey().register(new AuthValueFactoryProvider.Binder<>(User.class));
    }
}
