/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class KubernetesConfiguration {
    @NotNull
    private Boolean enabled = false;
    @JsonProperty(value="role")
    private String roles = "";

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isJobsPod() {
        return this.getRoles().contains((Object)KubernetesRole.JOBS);
    }

    public Collection<KubernetesRole> getRoles() {
        return Stream.of(this.roles.split(",")).peek(e -> System.out.println((String)e)).filter(role -> role.length() > 0).map(role -> KubernetesRole.fromString(role)).collect(Collectors.toList());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum KubernetesRole {
        JOBS("jobs"),
        SERVER("server");

        private final String nameInConfig;

        private KubernetesRole(String nameInConfig) {
            this.nameInConfig = nameInConfig;
        }

        public static KubernetesRole fromString(String input) {
            for (KubernetesRole role : KubernetesRole.values()) {
                if (!role.nameInConfig.equalsIgnoreCase(input)) continue;
                return role;
            }
            throw new IllegalArgumentException("Unable to create Role from string: " + input);
        }
    }
}

